/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class TriangleRotationHandle
extends AbstractHandle {
    private Point fOrigin = null;
    private Point fCenter = null;

    public TriangleRotationHandle(TriangleFigure owner) {
        super(owner);
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    Point getOrigin() {
        Polygon p = ((TriangleFigure)this.owner()).polygon();
        Point first = new Point(p.xpoints[0], p.ypoints[0]);
        Point ctr = this.owner().center();
        double len = Geom.length(first.x, first.y, ctr.x, ctr.y);
        if (len == 0.0) {
            return new Point(first.x - 4, first.y + 4);
        }
        double u = 8.0 / len;
        if (u > 1.0) {
            return new Point((first.x * 3 + ctr.x) / 4, (first.y * 3 + ctr.y) / 4);
        }
        return new Point((int)((double)first.x * (1.0 - u) + (double)ctr.x * u), (int)((double)first.y * (1.0 - u) + (double)ctr.y * u));
    }

    public void invokeEnd(int dx, int dy, Drawing drawing) {
        this.fOrigin = null;
        this.fCenter = null;
    }

    public void invokeStart(int x, int y, Drawing drawing) {
        this.fCenter = this.owner().center();
        this.fOrigin = this.getOrigin();
    }

    public void invokeStep(int dx, int dy, Drawing drawing) {
        double angle = Math.atan2(this.fOrigin.y + dy - this.fCenter.y, this.fOrigin.x + dx - this.fCenter.x);
        ((TriangleFigure)this.owner()).rotate(angle);
    }

    public Point locate() {
        return this.getOrigin();
    }
}

