/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.text.TextBlock;
import org.jfree.text.TextFragment;
import org.jfree.text.TextLine;
import org.jfree.ui.RectangleEdge;

public class ExtendedCategoryAxis
extends CategoryAxis {
    private Map sublabels = new HashMap();
    private Font sublabelFont = new Font("SansSerif", 0, 10);

    public ExtendedCategoryAxis(String string) {
        super(string);
    }

    public Font getSubLabelFont() {
        return this.sublabelFont;
    }

    public void setSubLabelFont(Font font) {
        this.sublabelFont = font;
    }

    public void addSubLabel(Comparable comparable, String string) {
        this.sublabels.put(comparable, string);
    }

    protected TextBlock createLabel(Comparable comparable, double d, RectangleEdge rectangleEdge) {
        TextBlock textBlock = super.createLabel(comparable, d, rectangleEdge);
        String string = (String)this.sublabels.get(comparable);
        if (string != null) {
            TextLine textLine;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                TextLine textLine2 = new TextLine(string, this.sublabelFont);
                textBlock.addLine(textLine2);
            } else if ((rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) && (textLine = textBlock.getLastLine()) != null) {
                textLine.addFragment(new TextFragment("  " + string, this.sublabelFont));
            }
        }
        return textBlock;
    }
}

