/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.event.EventListenerList;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;

public abstract class SearchQuery {
    protected EventListenerList listenerList = new EventListenerList();
    protected SearchEngine hs;
    protected String searchparams;
    protected Locale l;
    private static final boolean debug = false;
    static /* synthetic */ Class class$0;

    public SearchQuery(SearchEngine hs) {
        this.hs = hs;
    }

    public void addSearchListener(SearchListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.help.search.SearchListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeSearchListener(SearchListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.help.search.SearchListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    public void start(String searchparams, Locale l) throws IllegalArgumentException, IllegalStateException {
        this.searchparams = searchparams;
        this.l = l;
        this.fireSearchStarted();
    }

    public void stop() throws IllegalStateException {
        this.fireSearchFinished();
    }

    public SearchEngine getSearchEngine() {
        return this.hs;
    }

    public abstract boolean isActive();

    public void itemsFound(boolean inSearch, Vector docs) {
        this.fireItemsFound(inSearch, docs);
    }

    protected void fireItemsFound(boolean inSearch, Vector docs) {
        SearchQuery.debug("fireItemsFound");
        SearchQuery.debug("  params: " + this.searchparams);
        SearchQuery.debug("  insearch: " + inSearch);
        SearchQuery.debug("  docs: " + docs);
        Object[] listeners = this.listenerList.getListenerList();
        SearchEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.help.search.SearchListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new SearchEvent(this, this.searchparams, inSearch, docs);
                }
                ((SearchListener)listeners[i + 1]).itemsFound(e);
            }
            i -= 2;
        }
    }

    protected void fireItemsFound(SearchEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        Vector<SearchItem> newItems = new Vector<SearchItem>();
        Enumeration enumeration = e.getSearchItems();
        while (enumeration.hasMoreElements()) {
            newItems.addElement((SearchItem)enumeration.nextElement());
        }
        SearchEvent e2 = new SearchEvent(this, e.getParams(), e.isSearchCompleted(), newItems);
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.help.search.SearchListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((SearchListener)listeners[i + 1]).itemsFound(e2);
            }
            i -= 2;
        }
    }

    protected void fireSearchStarted() {
        SearchQuery.debug("fireSearchStarted");
        Object[] listeners = this.listenerList.getListenerList();
        SearchEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.help.search.SearchListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new SearchEvent(this, this.searchparams, true);
                }
                ((SearchListener)listeners[i + 1]).searchStarted(e);
            }
            i -= 2;
        }
    }

    protected void fireSearchFinished() {
        SearchQuery.debug("fireSearchFinished");
        Object[] listeners = this.listenerList.getListenerList();
        SearchEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.help.search.SearchListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new SearchEvent(this, this.searchparams, false);
                }
                ((SearchListener)listeners[i + 1]).searchFinished(e);
            }
            i -= 2;
        }
    }

    private static void debug(String msg) {
    }
}

