/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConfigFile {
    private String remove;
    private String prepend;
    private Hashtable stopWords;
    private String[] defStopWords = new String[]{"a", "all", "am", "an", "and", "any", "are", "as", "at", "be", "but", "by", "can", "could", "did", "do", "does", "etc", "for", "from", "goes", "got", "had", "has", "have", "he", "her", "him", "his", "how", "if", "in", "is", "it", "let", "me", "more", "much", "must", "my", "nor", "not", "now", "of", "off", "on", "or", "our", "own", "see", "set", "shall", "she", "should", "so", "some", "than", "that", "the", "them", "then", "there", "these", "this", "those", "though", "to", "too", "us", "was", "way", "we", "what", "when", "where", "which", "who", "why", "will", "would", "yes", "yet", "you"};
    private Vector files;

    public ConfigFile(String configFile, Vector files, boolean noStopWords) {
        this.files = files;
        String removeText = new String("IndexRemove ");
        String prependText = new String("IndexPrepend ");
        String fileText = new String("File ");
        String stopWordsText = new String("StopWords ");
        String stopWordsFileText = new String("StopWordsFile ");
        this.stopWords = new Hashtable();
        if (configFile == null) {
            if (!noStopWords) {
                this.useDefaultStopWords();
            }
            return;
        }
        try {
            String line;
            LineNumberReader in = new LineNumberReader(new BufferedReader(new FileReader(configFile)));
            while ((line = in.readLine()) != null) {
                String file;
                if (line.startsWith(removeText)) {
                    this.remove = line.substring(removeText.length(), line.length());
                    continue;
                }
                if (line.startsWith(prependText)) {
                    this.prepend = line.substring(prependText.length(), line.length());
                    continue;
                }
                if (line.startsWith(fileText)) {
                    file = line.substring(fileText.length(), line.length());
                    files.addElement(file);
                    continue;
                }
                if (line.startsWith(stopWordsFileText)) {
                    file = line.substring(stopWordsFileText.length(), line.length());
                    this.addStopWordsFile(file);
                    continue;
                }
                if (line.startsWith(stopWordsText)) {
                    if (noStopWords) continue;
                    String words = line.substring(stopWordsText.length(), line.length());
                    BreakIterator boundary = BreakIterator.getWordInstance();
                    boundary.setText(words);
                    int start = boundary.first();
                    int end = boundary.next();
                    while (end != -1) {
                        String word = words.substring(start, end).trim().toLowerCase();
                        if (!word.equals(",") && !word.equals("")) {
                            this.stopWords.put(word, word);
                        }
                        start = end;
                        end = boundary.next();
                    }
                    continue;
                }
                System.out.println("Unknown Config Keyword at line " + in.getLineNumber());
            }
            if (this.stopWords.isEmpty() && !noStopWords) {
                this.useDefaultStopWords();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getURLString(String file) {
        String url = this.remove != null && file.startsWith(this.remove) ? file.substring(this.remove.length(), file.length()) : file;
        if (this.prepend != null) {
            url = String.valueOf(this.prepend) + url;
        }
        if (File.separatorChar != '/') {
            url = url.replace(File.separatorChar, '/');
        }
        return url;
    }

    public Enumeration getStopWords() {
        return this.stopWords.elements();
    }

    public Vector getFiles() {
        return this.files;
    }

    private void useDefaultStopWords() {
        int i = 0;
        while (i < this.defStopWords.length) {
            this.stopWords.put(this.defStopWords[i], this.defStopWords[i]);
            ++i;
        }
    }

    private void addStopWordsFile(String swfile) {
        if (swfile == null) {
            return;
        }
        try {
            String word;
            LineNumberReader in = new LineNumberReader(new BufferedReader(new FileReader(swfile)));
            while ((word = in.readLine()) != null) {
                word = word.trim();
                this.stopWords.put(word, word);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

