/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Locale;
import javax.help.IndexItem;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class BasicIndexCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected static final Color selColor = new Color(0, 0, 128);
    protected static final Color defaultColor = Color.white;
    protected boolean selected;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    protected Color foregroundSelectionColor;
    protected Color foregroundColor;

    public BasicIndexCellRenderer() {
        this.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.setHorizontalAlignment(2);
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Locale locale;
        IndexItem item = (IndexItem)((DefaultMutableTreeNode)value).getUserObject();
        String stringValue = "";
        if (item != null) {
            stringValue = item.getName();
        }
        this.setText(stringValue);
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.selected = sel;
        if (item != null && (locale = item.getLocale()) != null) {
            this.setLocale(locale);
        }
        return this;
    }

    public void paint(Graphics g) {
        Color bColor;
        if (this.selected) {
            bColor = this.getBackgroundSelectionColor();
        } else {
            bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        if (bColor != null) {
            g.setColor(bColor);
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight());
        }
        if (this.selected) {
            g.setColor(this.getBorderSelectionColor());
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g);
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }
}

