/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import com.sun.java.help.impl.JHelpPrintHandler;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpUI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class BasicHelpUI
extends HelpUI
implements PropertyChangeListener,
Serializable {
    protected JHelp help;
    protected JToolBar toolbar;
    protected JSplitPane splitPane;
    protected JTabbedPane tabbedPane;
    protected Vector navs = new Vector();
    private Vector history = new Vector();
    private int historyIndex = -1;
    private static Dimension PREF_SIZE = new Dimension(600, 600);
    private static Dimension MIN_SIZE = new Dimension(300, 200);
    static boolean noPageSetup;
    static boolean on1dot1;
    private ImageIcon prev = this.getIcon("images/prev.gif");
    private ImageIcon next = this.getIcon("images/next.gif");
    private ImageIcon print = this.getIcon("images/print.gif");
    private ImageIcon pageSetup = this.getIcon("images/pageSetup.gif");
    private JButton prevButton;
    private JButton nextButton;
    private JButton printButton;
    private JButton pageSetupButton;
    private int dividerLocation = 0;
    private final double dividerLocationRatio = 0.3;
    private IdChangeListener changeListener = new IdChangeListener();
    private static boolean debug;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        on1dot1 = false;
        noPageSetup = false;
        try {
            Method m;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.awt.Toolkit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            noPageSetup = (m = clazz.getMethod("getMaximumCursorColors", null)) == null;
            on1dot1 = m == null;
        }
        catch (NoSuchMethodException e) {
            noPageSetup = true;
            on1dot1 = true;
        }
        if (!noPageSetup) {
            boolean on1dot2 = false;
            try {
                Method m;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.awt.datatransfer.DataFlavor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                on1dot2 = (m = clazz.getMethod("getTextPlainUnicodeFlavor", null)) == null;
            }
            catch (NoSuchMethodException e) {
                on1dot2 = true;
            }
            String[] osName = new String[]{""};
            osName[0] = System.getProperty("os.name");
            if (osName[0] != null && (osName[0].indexOf("Solaris") != -1 || osName[0].indexOf("SunOS") != -1) && on1dot2) {
                noPageSetup = true;
            }
        }
        debug = false;
    }

    public static ComponentUI createUI(JComponent x) {
        return new BasicHelpUI((JHelp)x);
    }

    public BasicHelpUI(JHelp b) {
        BasicHelpUI.debug("createUI - sort of");
    }

    public void installUI(JComponent c) {
        BasicHelpUI.debug("installUI");
        this.help = (JHelp)c;
        this.help.setLayout(new BorderLayout());
        this.help.addPropertyChangeListener(this);
        HelpModel hm = this.getModel();
        if (hm != null) {
            hm.addHelpModelListener(this.changeListener);
        }
        this.toolbar = this.createToolBar(HelpUtilities.getLocale(c));
        this.toolbar.setFloatable(false);
        this.help.add("North", this.toolbar);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setVisible(false);
        this.splitPane = new JSplitPane(1, false, this.tabbedPane, this.help.getContentViewer());
        this.splitPane.setOneTouchExpandable(true);
        this.help.add("Center", this.splitPane);
        this.rebuild();
    }

    protected JToolBar createToolBar(Locale locale) {
        this.toolbar = new JToolBar();
        this.prevButton = new JButton(this.prev);
        this.prevButton.setEnabled(false);
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicHelpUI.this.goBack();
            }
        });
        this.prevButton.setToolTipText(HelpUtilities.getString(locale, "tip.previous"));
        this.nextButton = new JButton(this.next);
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicHelpUI.this.goForward();
            }
        });
        this.nextButton.setToolTipText(HelpUtilities.getString(locale, "tip.next"));
        try {
            JHelpPrintHandler ph;
            block23: {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    security.checkPrintJobAccess();
                }
                ph = null;
                this.printButton = new JButton(this.print);
                try {
                    if (on1dot1) {
                        Class<?> c = Class.forName("com.sun.java.help.impl.JHelpPrintHandler");
                        Class[] classArray = new Class[2];
                        Class<?> clazz = class$2;
                        if (clazz == null) {
                            try {
                                clazz = class$2 = Class.forName("javax.help.HelpModel");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz;
                        Class<?> clazz2 = class$3;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$3 = Class.forName("java.awt.Component");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[1] = clazz2;
                        Constructor<?> constr = c.getConstructor(classArray);
                        ph = (JHelpPrintHandler)constr.newInstance(this.getModel(), this.printButton);
                        break block23;
                    }
                    Class<?> c = Class.forName("com.sun.java.help.impl.JHelpPrintHandler1_2");
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("javax.help.HelpModel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Class<?> clazz3 = class$3;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$3 = Class.forName("java.awt.Component");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz3;
                    Constructor<?> constr = c.getConstructor(classArray);
                    ph = (JHelpPrintHandler)constr.newInstance(this.getModel(), this.printButton);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.printButton.addActionListener(ph);
            this.printButton.setToolTipText(HelpUtilities.getString(locale, "tip.print"));
            this.pageSetupButton = null;
            if (!noPageSetup) {
                this.pageSetupButton = new JButton(this.pageSetup);
                ph.handlePageSetup(this.pageSetupButton);
                this.pageSetupButton.addActionListener(ph);
                this.pageSetupButton.setToolTipText(HelpUtilities.getString(locale, "tip.pageSetup"));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.toolbar.add(this.prevButton);
        this.toolbar.add(this.nextButton);
        this.toolbar.add(new JToolBar.Separator());
        if (this.printButton != null) {
            this.toolbar.add(this.printButton);
        }
        if (this.pageSetupButton != null) {
            this.toolbar.add(this.pageSetupButton);
        }
        return this.toolbar;
    }

    public void uninstallUI(JComponent c) {
        BasicHelpUI.debug("uninstallUI");
        this.help.removePropertyChangeListener(this);
        this.help.setLayout(null);
        this.help.removeAll();
        HelpModel hm = this.getModel();
        if (hm != null) {
            hm.removeHelpModelListener(this.changeListener);
        }
        this.help = null;
        this.toolbar = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return PREF_SIZE;
    }

    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private void rebuild() {
        HelpModel hm = this.getModel();
        if (hm == null) {
            return;
        }
        this.discardHistory();
        HelpSet hs = hm.getHelpSet();
        JHelpContentViewer contentViewer = this.help.getContentViewer();
        try {
            Map.ID id = hs.getHomeID();
            contentViewer.setCurrentID(id);
            Map map = hs.getCombinedMap();
            URL url = map.getURLFromID(id);
        }
        catch (MalformedURLException e2) {
            BasicHelpUI.debug("No HomeID found - ignoring it...");
            return;
        }
        catch (Exception ex) {
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        BasicHelpUI.debug("propertyChange: " + event.getPropertyName());
        if (event.getSource() == this.help) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                this.rebuild();
            } else if (changeName.equals("font")) {
                BasicHelpUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.help.getContentViewer().setFont(newFont);
                this.help.getContentViewer().invalidate();
                Enumeration entries = this.help.getHelpNavigators();
                while (entries.hasMoreElements()) {
                    JHelpNavigator nav = (JHelpNavigator)entries.nextElement();
                    nav.setFont(newFont);
                }
            } else if (changeName.equals("navigatorDisplayed")) {
                this.tabbedPane.setVisible((Boolean)event.getNewValue());
            }
        }
    }

    protected HelpModel getModel() {
        if (this.help == null) {
            return null;
        }
        return this.help.getModel();
    }

    public void addNavigator(JHelpNavigator nav) {
        BasicHelpUI.debug("addNavigator");
        this.navs.addElement(nav);
        Icon icon = nav.getIcon();
        if (icon != null) {
            this.tabbedPane.addTab("", icon, nav, nav.getNavigatorLabel());
        } else {
            String name = nav.getName();
            if (name == null) {
                name = "<unknown>";
            }
            this.tabbedPane.addTab(name, icon, nav);
        }
        this.tabbedPane.setVisible(this.help.isNavigatorDisplayed());
        this.help.invalidate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if ((double)BasicHelpUI.this.dividerLocation == 0.0) {
                    Dimension dem = BasicHelpUI.this.splitPane.getSize();
                    if (dem.width != 0) {
                        BasicHelpUI.this.splitPane.setDividerLocation((int)((double)(dem.width - BasicHelpUI.this.splitPane.getDividerSize()) * 0.3));
                    }
                    BasicHelpUI.this.dividerLocation = BasicHelpUI.this.splitPane.getDividerLocation();
                }
            }
        });
    }

    public void removeNavigator(JHelpNavigator nav) {
        BasicHelpUI.debug("removeNavigator");
        this.navs.removeElement(nav);
        this.tabbedPane.remove(nav);
        this.help.invalidate();
    }

    public Enumeration getHelpNavigators() {
        return this.navs.elements();
    }

    public void setCurrentNavigator(JHelpNavigator nav) {
        if (nav == (JHelpNavigator)this.tabbedPane.getSelectedComponent()) {
            return;
        }
        int size = this.navs.size();
        int i = 0;
        while (i < size) {
            JHelpNavigator test = (JHelpNavigator)this.navs.elementAt(i);
            if (test == nav) {
                this.tabbedPane.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("JHelpNavigator must be added first");
    }

    public JHelpNavigator getCurrentNavigator() {
        return (JHelpNavigator)this.tabbedPane.getSelectedComponent();
    }

    private ImageIcon getIcon(String name) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("javax.help.plaf.basic.BasicHelpUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return BasicHelpUI.getIcon(clazz, name);
    }

    public static ImageIcon getIcon(Class klass, String name) {
        ImageIcon ig = null;
        try {
            ig = HelpUtilities.getImageIcon(klass, name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (debug || ig == null) {
            System.err.println("GetIcon");
            System.err.println("  name: " + name);
            System.err.println("  klass: " + klass);
            URL url = klass.getResource(name);
            System.err.println("  URL is " + url);
            System.err.println("  ImageIcon is " + ig);
        }
        return ig;
    }

    private void computeHistoryButtons() {
        BasicHelpUI.debug("computeHistoryButtons");
        BasicHelpUI.debug("  historyIndex" + this.historyIndex);
        BasicHelpUI.debug("  history.size" + this.history.size());
        this.prevButton.setEnabled(this.historyIndex > 0);
        this.nextButton.setEnabled(this.historyIndex < this.history.size() - 1);
    }

    private void discardHistory() {
        this.history.setSize(0);
        this.historyIndex = -1;
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
    }

    protected void goBack() {
        this.gotoHistoryEntry(this.historyIndex - 1);
    }

    protected void goForward() {
        this.gotoHistoryEntry(this.historyIndex + 1);
    }

    private void gotoHistoryEntry(int index) {
        BasicHelpUI.debug("gotoHistoryEntry(" + index + ")");
        HelpModel hm = this.getModel();
        if (hm == null) {
            return;
        }
        if (index < 0 || index >= this.history.size()) {
            this.discardHistory();
            return;
        }
        HelpModelEvent e = (HelpModelEvent)this.history.elementAt(index);
        this.historyIndex = index - 1;
        Map.ID id = e.getID();
        URL url = e.getURL();
        if (id != null) {
            try {
                BasicHelpUI.debug("  setCurrentID" + id);
                hm.setCurrentID(id);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (url != null) {
            try {
                BasicHelpUI.debug("  setCurrentURL" + url);
                hm.setCurrentURL(url);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.discardHistory();
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicHelpUI: " + str);
        }
    }

    private class IdChangeListener
    implements HelpModelListener {
        IdChangeListener() {
        }

        public void idChanged(HelpModelEvent e) {
            BasicHelpUI.debug("idChanged(" + e + ")");
            BasicHelpUI.debug("  historyIndex==" + BasicHelpUI.this.historyIndex);
            BasicHelpUI.debug("  history.size==" + BasicHelpUI.this.history.size());
            if (BasicHelpUI.this.historyIndex == BasicHelpUI.this.history.size() - 1) {
                BasicHelpUI.this.history.addElement(e);
                BasicHelpUI basicHelpUI = BasicHelpUI.this;
                basicHelpUI.historyIndex = basicHelpUI.historyIndex + 1;
                BasicHelpUI.this.computeHistoryButtons();
                return;
            }
            if (BasicHelpUI.this.historyIndex >= -1 && BasicHelpUI.this.historyIndex < BasicHelpUI.this.history.size() - 1) {
                BasicHelpUI basicHelpUI = BasicHelpUI.this;
                basicHelpUI.historyIndex = basicHelpUI.historyIndex + 1;
                HelpModelEvent h = (HelpModelEvent)BasicHelpUI.this.history.elementAt(BasicHelpUI.this.historyIndex);
                if (h == null) {
                    BasicHelpUI.this.discardHistory();
                    return;
                }
                if (h.getID() != null && e.getID() != null && h.getID().equals(e.getID())) {
                    BasicHelpUI.this.computeHistoryButtons();
                    return;
                }
                if (h.getURL() != null && e.getURL() != null && h.getURL().sameFile(e.getURL())) {
                    BasicHelpUI.this.computeHistoryButtons();
                    return;
                }
                BasicHelpUI.this.history.setSize(BasicHelpUI.this.historyIndex);
                BasicHelpUI.this.history.addElement(e);
                BasicHelpUI.this.computeHistoryButtons();
            }
        }
    }
}

