/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import javax.swing.ImageIcon;

public class BasicCursorFactory {
    private static Cursor onItemCursor;
    private static BasicCursorFactory theFactory;
    private static final boolean debug = false;

    public static Cursor getOnItemCursor() {
        BasicCursorFactory.debug("getOnItemCursor");
        if (theFactory == null) {
            theFactory = new BasicCursorFactory();
        }
        if (onItemCursor == null) {
            onItemCursor = theFactory.createCursor("OnItemCursor");
        }
        return onItemCursor;
    }

    private Cursor createCursor(String name) {
        String gifFile = null;
        String hotspot = null;
        BasicCursorFactory.debug("CreateCursor for " + name);
        InputStream is = this.getClass().getResourceAsStream("images/" + name + ".properties");
        if (is == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + "/" + "images/" + name + ".properties" + " not found.");
            return null;
        }
        try {
            PropertyResourceBundle resource = new PropertyResourceBundle(is);
            gifFile = resource.getString("Cursor.File");
            hotspot = resource.getString("Cursor.HotSpot");
        }
        catch (MissingResourceException e) {
            System.err.println(String.valueOf(this.getClass().getName()) + "/" + "images/" + name + ".properties" + " invalid.");
            return null;
        }
        catch (IOException e2) {
            System.err.println(String.valueOf(this.getClass().getName()) + "/" + "images/" + name + ".properties" + " invalid.");
            return null;
        }
        byte[] buffer = null;
        try {
            int n;
            InputStream resource = this.getClass().getResourceAsStream(gifFile);
            if (resource == null) {
                System.err.println(String.valueOf(this.getClass().getName()) + "/" + gifFile + " not found.");
                return null;
            }
            BufferedInputStream in = new BufferedInputStream(resource);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            buffer = new byte[1024];
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
            in.close();
            out.flush();
            buffer = out.toByteArray();
            if (buffer.length == 0) {
                System.err.println("warning: " + gifFile + " is zero-length");
                return null;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            return null;
        }
        ImageIcon icon = new ImageIcon(buffer);
        int k = hotspot.indexOf(44);
        Point point = new Point(Integer.parseInt(hotspot.substring(0, k)), Integer.parseInt(hotspot.substring(k + 1)));
        BasicCursorFactory.debug("Toolkit fetching cursor");
        try {
            return Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), point, name);
        }
        catch (NoSuchMethodError err) {
            return null;
        }
    }

    private static void debug(String str) {
    }
}

