/*
 * Decompiled with CFR 0.152.
 */
package javax.help.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient Object[] listenerList = NULL_ARRAY;

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class t) {
        int count = 0;
        Object[] lList = this.listenerList;
        int i = 0;
        while (i < lList.length) {
            if (t == (Class)lList[i]) {
                ++count;
            }
            i += 2;
        }
        return count;
    }

    public synchronized void add(Class t, EventListener l) {
        if (l == null || t == null) {
            throw new IllegalArgumentException("Listener " + l + " is null");
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{t, l};
        } else {
            int i = this.listenerList.length;
            Object[] tmp = new Object[i + 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, i);
            tmp[i] = t;
            tmp[i + 1] = l;
            this.listenerList = tmp;
        }
    }

    public synchronized void remove(Class t, EventListener l) {
        if (l == null || t == null) {
            throw new IllegalArgumentException("Listener " + l + " is null");
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        int index = -1;
        int i = this.listenerList.length - 2;
        while (i >= 0) {
            if (this.listenerList[i] == t && this.listenerList[i + 1] == l) {
                index = i;
                break;
            }
            i -= 2;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listenerList, index + 2, tmp, index, tmp.length - index);
            }
            this.listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] lList = this.listenerList;
        s.defaultWriteObject();
        int i = 0;
        while (i < lList.length) {
            Class t = (Class)lList[i];
            EventListener l = (EventListener)lList[i + 1];
            if (l != null && l instanceof Serializable) {
                s.writeObject(t.getName());
                s.writeObject(l);
            }
            i += 2;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object listenerTypeOrNull;
        this.listenerList = NULL_ARRAY;
        s.defaultReadObject();
        while ((listenerTypeOrNull = s.readObject()) != null) {
            EventListener l = (EventListener)s.readObject();
            this.add(Class.forName((String)listenerTypeOrNull), l);
        }
    }

    public String toString() {
        Object[] lList = this.listenerList;
        String s = "EventListenerList: ";
        s = String.valueOf(s) + lList.length / 2 + " listeners: ";
        int i = 0;
        while (i <= lList.length - 2) {
            s = String.valueOf(s) + " type " + ((Class)lList[i]).getName();
            s = String.valueOf(s) + " listener " + lList[i + 1];
            i += 2;
        }
        return s;
    }
}

