/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.Map;
import javax.help.SearchHit;
import javax.help.TOCItem;
import javax.help.search.SearchItem;

public class SearchTOCItem
extends TOCItem {
    private URL url;
    private Vector sivec;
    private boolean inTOC;
    private double confidence;

    public SearchTOCItem(Map.ID id, Map.ID imageID, HelpSet hs, Locale locale) {
        super(id, imageID, hs, locale);
        this.inTOC = true;
        this.url = null;
        this.sivec = new Vector();
        this.confidence = 0.0;
    }

    public SearchTOCItem(SearchItem item) {
        super(null, null, null, HelpUtilities.localeFromLang(item.getLang()));
        this.inTOC = false;
        this.setName(item.getTitle());
        try {
            this.url = new URL(item.getBase(), item.getFilename());
        }
        catch (MalformedURLException me) {
            this.url = null;
        }
        this.sivec = new Vector();
        SearchHit info = new SearchHit(item.getConfidence(), item.getBegin(), item.getEnd());
        this.confidence = item.getConfidence();
        this.sivec.addElement(info);
    }

    public void addSearchHit(SearchHit si) {
        if (this.sivec.isEmpty()) {
            this.sivec.addElement(si);
            this.confidence = si.getConfidence();
        } else {
            int i = this.sivec.size() - 1;
            while (i >= 0) {
                SearchHit test = (SearchHit)this.sivec.elementAt(i);
                if (test.getConfidence() <= si.getConfidence()) {
                    this.sivec.insertElementAt(si, i + 1);
                    break;
                }
                if (i == 0) {
                    this.sivec.insertElementAt(si, 0);
                    this.confidence = si.getConfidence();
                }
                --i;
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public Enumeration getConfidences() {
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < SearchTOCItem.this.sivec.size();
            }

            public Object nextElement() {
                Vector vector = SearchTOCItem.this.sivec;
                synchronized (vector) {
                    if (this.count < SearchTOCItem.this.sivec.size()) {
                        return new Double(((SearchHit)SearchTOCItem.this.sivec.elementAt(this.count++)).getConfidence());
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public boolean inTOC() {
        return this.inTOC;
    }

    public Enumeration getSearchHits() {
        return this.sivec.elements();
    }

    public int hitCount() {
        return this.sivec.size();
    }
}

