/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidNavigatorViewException;
import javax.help.JHelpNavigator;
import javax.help.NavigatorView;
import javax.help.SearchView;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;

public class JHelpSearchNavigator
extends JHelpNavigator {
    private MergingSearchEngine search;
    private static final boolean debug = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JHelpSearchNavigator(NavigatorView view) {
        super(view, null);
    }

    public JHelpSearchNavigator(NavigatorView view, HelpModel model) {
        super(view, model);
    }

    public JHelpSearchNavigator(HelpSet hs, String name, String label, URL data) throws InvalidNavigatorViewException {
        super(new SearchView(hs, name, label, JHelpNavigator.createParams(data)));
    }

    public String getUIClassID() {
        return "HelpSearchNavigatorUI";
    }

    public SearchEngine getSearchEngine() {
        if (this.search == null) {
            this.search = new MergingSearchEngine(this.getNavigatorView());
        }
        return this.search;
    }

    private SearchEngine makeEngine(NavigatorView view) {
        Constructor<?> konstructor;
        Class<?> klass;
        Hashtable params = view.getParameters();
        if (params == null || params != null && !params.containsKey("data")) {
            return null;
        }
        String engineName = (String)params.get("engine");
        HelpSet hs = view.getHelpSet();
        URL base = hs.getHelpSetURL();
        ClassLoader loader = hs.getLoader();
        if (engineName == null) {
            engineName = this.getDefaultQueryEngine();
            params.put("engine", engineName);
        }
        SearchEngine back = null;
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] types = classArray;
        Object[] args = new Object[]{base, params};
        JHelpSearchNavigator.debug("makeEngine");
        JHelpSearchNavigator.debug("  base: " + base);
        JHelpSearchNavigator.debug("  params: " + params);
        try {
            klass = loader == null ? Class.forName(engineName) : loader.loadClass(engineName);
        }
        catch (Throwable t) {
            throw new Error("Could not load engine named " + engineName + " for view: " + view);
        }
        try {
            konstructor = klass.getConstructor(types);
        }
        catch (Throwable t) {
            throw new Error("Could not find constructor for " + engineName + ". For view: " + view);
        }
        try {
            back = (SearchEngine)konstructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new Error("InvocationTargetException while creating engine named " + engineName + " for view: " + view);
        }
        catch (Throwable t) {
            throw new Error("Could not create engine named " + engineName + " for view: " + view);
        }
        return back;
    }

    public void setSearchEngine(SearchEngine search) {
        this.search = new MergingSearchEngine(search);
    }

    protected String getDefaultQueryEngine() {
        return "com.sun.java.help.search.DefaultSearchEngine";
    }

    public boolean canMerge(NavigatorView view) {
        if (view instanceof SearchView && this.getNavigatorName().equals(view.getName())) {
            JHelpSearchNavigator.debug("canMerge: true");
            return true;
        }
        JHelpSearchNavigator.debug("canMerge: false");
        return false;
    }

    public void merge(NavigatorView view) {
        JHelpSearchNavigator.debug("JHelpSearchNavigator.merge invoked");
        JHelpSearchNavigator.debug("  params: " + view.getParameters());
        if (this.search == null) {
            this.search = (MergingSearchEngine)this.getSearchEngine();
        }
        this.search.merge(view);
        JHelpSearchNavigator.debug("merge: " + view);
        this.getUI().merge(view);
    }

    public void remove(NavigatorView view) {
        JHelpSearchNavigator.debug("JHelpSearchNavigator.remove invoked");
        JHelpSearchNavigator.debug("  params: " + view.getParameters());
        if (this.search == null) {
            this.search = (MergingSearchEngine)this.getSearchEngine();
        }
        this.search.remove(view);
        JHelpSearchNavigator.debug("remove: " + view);
        this.getUI().remove(view);
    }

    private static void debug(String msg) {
    }

    private class MergingSearchEngine
    extends SearchEngine {
        private Vector engines;
        private Hashtable enginePerView = new Hashtable();

        public MergingSearchEngine(NavigatorView view) {
            this.engines = new Vector();
            SearchEngine engine = JHelpSearchNavigator.this.makeEngine(view);
            this.engines.addElement(engine);
        }

        public MergingSearchEngine(SearchEngine engine) {
            this.engines = new Vector();
            this.engines.addElement(engine);
        }

        public SearchQuery createQuery() {
            return new MergingSearchQuery(this);
        }

        public void merge(NavigatorView view) {
            SearchEngine engine = JHelpSearchNavigator.this.makeEngine(view);
            if (engine == null) {
                return;
            }
            this.engines.addElement(engine);
            this.enginePerView.put(view, engine);
        }

        public void remove(NavigatorView view) {
            SearchEngine engine = (SearchEngine)this.enginePerView.get(view);
            if (engine != null) {
                this.engines.removeElement(engine);
                this.enginePerView.remove(engine);
            }
        }

        public Enumeration getEngines() {
            return this.engines.elements();
        }
    }

    private class MergingSearchQuery
    extends SearchQuery
    implements SearchListener {
        private MergingSearchEngine mhs;
        private Vector queries;
        private String searchparams;

        public MergingSearchQuery(SearchEngine hs) {
            super(hs);
            if (hs instanceof MergingSearchEngine) {
                this.mhs = (MergingSearchEngine)hs;
            }
        }

        public synchronized void start(String searchparams, Locale l) throws IllegalArgumentException, IllegalStateException {
            JHelpSearchNavigator.debug("startSearch()");
            if (this.isActive()) {
                throw new IllegalStateException();
            }
            super.start(searchparams, l);
            this.queries = new Vector();
            Enumeration e = this.mhs.getEngines();
            while (e.hasMoreElements()) {
                SearchEngine engine = (SearchEngine)e.nextElement();
                if (engine == null) continue;
                this.queries.addElement(engine.createQuery());
            }
            e = this.queries.elements();
            while (e.hasMoreElements()) {
                SearchQuery query = (SearchQuery)e.nextElement();
                query.addSearchListener(this);
                query.start(searchparams, l);
            }
        }

        public synchronized void stop() throws IllegalStateException {
            if (this.queries == null) {
                return;
            }
            this.queries = null;
        }

        public boolean isActive() {
            if (this.queries == null) {
                return false;
            }
            Enumeration e = this.queries.elements();
            while (e.hasMoreElements()) {
                SearchQuery query = (SearchQuery)e.nextElement();
                if (!query.isActive()) continue;
                return true;
            }
            return false;
        }

        public SearchEngine getSearchEngine() {
            return this.mhs;
        }

        public synchronized void itemsFound(SearchEvent e) {
            SearchQuery queryin = (SearchQuery)e.getSource();
            if (this.queries != null) {
                Enumeration enumeration = this.queries.elements();
                while (enumeration.hasMoreElements()) {
                    SearchQuery query = (SearchQuery)enumeration.nextElement();
                    if (query != queryin) continue;
                    this.fireItemsFound(e);
                }
            }
        }

        public void searchStarted(SearchEvent e) {
        }

        public synchronized void searchFinished(SearchEvent e) {
            SearchQuery queryin = (SearchQuery)e.getSource();
            if (this.queries != null) {
                Enumeration enumeration = this.queries.elements();
                while (enumeration.hasMoreElements()) {
                    SearchQuery query = (SearchQuery)enumeration.nextElement();
                    if (query != queryin) continue;
                    queryin.removeSearchListener(this);
                    this.queries.removeElement(query);
                }
                if (this.queries.isEmpty()) {
                    this.queries = null;
                    this.fireSearchFinished();
                }
            }
        }
    }
}

