/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.CollationElementIterator;
import java.text.MessageFormat;
import java.text.RuleBasedCollator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class HelpUtilities
implements PropertyChangeListener {
    private static HelpUtilities myLAFListener = new HelpUtilities();
    static Object basicOnItemCursor = new UIDefaults.LazyValue(){

        public Object createValue(UIDefaults table) {
            return HelpUtilities.createIcon("javax.help.plaf.basic.BasicCursorFactory", "getOnItemCursor");
        }
    };
    private static Hashtable tailsPerLocales = new Hashtable();
    private static Hashtable bundles;
    private static ResourceBundle lastBundle;
    private static Locale lastLocale;
    private static final boolean debug = false;
    static /* synthetic */ Class class$0;

    static {
        lastBundle = null;
        lastLocale = null;
    }

    private HelpUtilities() {
        UIManager.addPropertyChangeListener(this);
    }

    public static String getHelpSetNameFromBean(Class beanClass) {
        String helpSetName;
        try {
            BeanInfo bi = Introspector.getBeanInfo(beanClass);
            helpSetName = (String)bi.getBeanDescriptor().getValue("helpSetName");
        }
        catch (Exception ex) {
            helpSetName = null;
        }
        if (helpSetName == null) {
            String className = beanClass.getName();
            int index = className.lastIndexOf(".");
            if (index == -1) {
                helpSetName = String.valueOf(className) + "Help.hs";
            } else {
                String packageName = className.substring(0, index);
                helpSetName = String.valueOf(packageName.replace('.', '/')) + "/Help.hs";
            }
        }
        return helpSetName;
    }

    public static String getIDStringFromBean(Class beanClass) {
        String helpID;
        try {
            BeanInfo bi = Introspector.getBeanInfo(beanClass);
            helpID = (String)bi.getBeanDescriptor().getValue("helpID");
        }
        catch (Exception ex) {
            helpID = null;
        }
        if (helpID == null) {
            String className = beanClass.getName();
            helpID = String.valueOf(className) + ".topID";
        }
        return helpID;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String changeName = event.getPropertyName();
        if (changeName.equals("lookAndFeel")) {
            HelpUtilities.installLookAndFeelDefaults();
        }
    }

    static void installLookAndFeelDefaults() {
        LookAndFeel lnf = UIManager.getLookAndFeel();
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        HelpUtilities.debug("installLookAndFeelDefaults - ", lnf);
        if (lnf != null && table != null) {
            if (lnf.getID().equals("Motif")) {
                HelpUtilities.installMotifDefaults(table);
            } else if (lnf.getID().equals("Windows")) {
                HelpUtilities.installWindowsDefaults(table);
            } else {
                HelpUtilities.installMetalDefaults(table);
            }
        }
        HelpUtilities.debug("verifing UIDefaults; HelpUI=" + table.getString("HelpUI"));
    }

    private static Object createIcon(String factoryName, String method) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.help.HelpUtilities");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader loader = clazz.getClassLoader();
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Class<?> klass = loader == null ? Class.forName(factoryName) : loader.loadClass(factoryName);
            Method m = klass.getMethod(method, types);
            Object back = m.invoke(null, args);
            return back;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void installBasicDefaults(UIDefaults table) {
        String basicPackageName = "javax.help.plaf.basic.";
        Object[] uiDefaults = new Object[]{"HelpUI", String.valueOf(basicPackageName) + "BasicHelpUI", "HelpTOCNavigatorUI", String.valueOf(basicPackageName) + "BasicTOCNavigatorUI", "HelpIndexNavigatorUI", String.valueOf(basicPackageName) + "BasicIndexNavigatorUI", "HelpSearchNavigatorUI", String.valueOf(basicPackageName) + "BasicSearchNavigatorUI", "HelpContentViewerUI", String.valueOf(basicPackageName) + "BasicContentViewerUI", "HelpOnItemCursor", basicOnItemCursor};
        table.putDefaults(uiDefaults);
    }

    private static void installMetalDefaults(UIDefaults table) {
        HelpUtilities.installBasicDefaults(table);
    }

    private static void installWindowsDefaults(UIDefaults table) {
        HelpUtilities.installBasicDefaults(table);
    }

    private static void installMotifDefaults(UIDefaults table) {
        HelpUtilities.installBasicDefaults(table);
    }

    public static URL getLocalizedResource(ClassLoader cl, String front, String back, Locale locale) {
        return HelpUtilities.getLocalizedResource(cl, front, back, locale, false);
    }

    public static URL getLocalizedResource(ClassLoader cl, String front, String back, Locale locale, boolean tryRead) {
        Enumeration tails = HelpUtilities.getCandidates(locale);
        while (tails.hasMoreElements()) {
            String tail = (String)tails.nextElement();
            String name = front + tail + back;
            URL url = cl == null ? ClassLoader.getSystemResource(name) : cl.getResource(name);
            if (url == null) continue;
            if (tryRead) {
                try {
                    InputStream is = url.openConnection().getInputStream();
                    if (is == null) continue;
                    int i = is.read();
                    is.close();
                    if (i == -1) continue;
                    return url;
                }
                catch (Throwable t) {}
                continue;
            }
            return url;
        }
        return null;
    }

    public static synchronized Enumeration getCandidates(Locale locale) {
        LocalePair pair = new LocalePair(locale, Locale.getDefault());
        Vector<String> tails = (Vector<String>)tailsPerLocales.get(pair);
        if (tails != null) {
            HelpUtilities.debug("getCandidates - cached copy");
            return tails.elements();
        }
        String lname1 = locale.toString();
        StringBuffer name1 = new StringBuffer("_").append(lname1);
        if (lname1 == null) {
            name1.setLength(0);
        }
        tails = new Vector<String>();
        while (name1.length() != 0) {
            HelpUtilities.debug("  adding ", name1);
            String s = name1.toString();
            tails.addElement(s);
            int lastUnder = s.lastIndexOf(95);
            if (lastUnder == -1) continue;
            name1.setLength(lastUnder);
        }
        HelpUtilities.debug("  addign -- null -- ");
        tails.addElement("");
        if (locale != Locale.getDefault()) {
            String lname2 = Locale.getDefault().toString();
            StringBuffer name2 = new StringBuffer("_").append(lname2);
            if (lname2 == null) {
                name2.setLength(0);
            }
            while (name2.length() != 0) {
                HelpUtilities.debug("  adding ", name2);
                String s = name2.toString();
                tails.addElement(s);
                int lastUnder = s.lastIndexOf(95);
                if (lastUnder == -1) continue;
                name2.setLength(lastUnder);
            }
        }
        tailsPerLocales.put(pair, tails);
        HelpUtilities.debug("tails is == ", tails);
        return tails.elements();
    }

    public static ImageIcon getImageIcon(Class baseClass, String image) {
        if (image == null) {
            return null;
        }
        byte[][] buffer = new byte[1][];
        try {
            int n;
            InputStream resource = baseClass.getResourceAsStream(image);
            if (resource == null) {
                return null;
            }
            BufferedInputStream in = new BufferedInputStream(resource);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            buffer[0] = new byte[1024];
            while ((n = in.read(buffer[0])) > 0) {
                out.write(buffer[0], 0, n);
            }
            in.close();
            out.flush();
            buffer[0] = out.toByteArray();
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            return null;
        }
        if (buffer[0] == null) {
            System.err.println(String.valueOf(baseClass.getName()) + "/" + image + " not found.");
            return null;
        }
        if (buffer[0].length == 0) {
            System.err.println("warning: " + image + " is zero-length");
            return null;
        }
        return new ImageIcon(buffer[0]);
    }

    public static Locale getLocale(Component c) {
        if (c == null) {
            return Locale.getDefault();
        }
        try {
            return c.getLocale();
        }
        catch (IllegalComponentStateException ex) {
            return Locale.getDefault();
        }
    }

    private static synchronized ResourceBundle getBundle(Locale l) {
        ResourceBundle back;
        if (lastLocale == l) {
            return lastBundle;
        }
        if (bundles == null) {
            bundles = new Hashtable();
        }
        if ((back = (ResourceBundle)bundles.get(l)) == null) {
            try {
                back = ResourceBundle.getBundle("javax.help.resources.Constants", l);
            }
            catch (MissingResourceException ex) {
                throw new Error("Fatal: Resource for javahelp is missing");
            }
            bundles.put(l, back);
        }
        lastBundle = back;
        lastLocale = l;
        return back;
    }

    public static String getString(String key) {
        return HelpUtilities.getString(Locale.getDefault(), key);
    }

    public static String getText(String key) {
        return HelpUtilities.getText(Locale.getDefault(), key, null, null);
    }

    public static String getText(String key, String s1) {
        return HelpUtilities.getText(Locale.getDefault(), key, s1, null);
    }

    public static String getText(String key, String s1, String s2) {
        return HelpUtilities.getText(Locale.getDefault(), key, s1, s2);
    }

    public static String getText(String key, String s1, String s2, String s3) {
        return HelpUtilities.getText(Locale.getDefault(), key, s1, s2, s3);
    }

    public static String getString(Locale l, String key) {
        ResourceBundle bundle = HelpUtilities.getBundle(l);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            throw new Error("Fatal: Localization data for JavaHelp is broken.  Missing " + key + " key.");
        }
    }

    public static String[] getStringArray(Locale l, String key) {
        ResourceBundle bundle = HelpUtilities.getBundle(l);
        try {
            return bundle.getStringArray(key);
        }
        catch (MissingResourceException ex) {
            throw new Error("Fatal: Localization data for JavaHelp is broken.  Missing " + key + " key.");
        }
    }

    public static String getText(Locale l, String key) {
        return HelpUtilities.getText(l, key, null, null, null);
    }

    public static String getText(Locale l, String key, String s1) {
        return HelpUtilities.getText(l, key, s1, null, null);
    }

    public static String getText(Locale l, String key, String s1, String s2) {
        return HelpUtilities.getText(l, key, s1, s2, null);
    }

    public static String getText(Locale l, String key, String s1, String s2, String s3) {
        ResourceBundle bundle = HelpUtilities.getBundle(l);
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        try {
            String fmt = bundle.getString(key);
            String[] args = new String[]{s1, s2, s3};
            MessageFormat format = new MessageFormat(fmt);
            try {
                format.setLocale(l);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return format.format(args);
        }
        catch (MissingResourceException ex) {
            throw new Error("Fatal: Localization data for JavaHelp is broken.  Missing " + key + " key.");
        }
    }

    public static Locale localeFromLang(String lang) {
        String variant = null;
        Locale newlocale = null;
        if (lang == null) {
            return newlocale;
        }
        int lpt = lang.indexOf("_");
        if (lpt == -1) {
            String language = lang;
            String country = "";
            newlocale = new Locale(language, country);
        } else {
            String language = lang.substring(0, lpt);
            int cpt = lang.indexOf("_", lpt + 1);
            if (cpt == -1) {
                String country = lang.substring(lpt + 1);
                newlocale = new Locale(language, country);
            } else {
                String country = lang.substring(lpt + 1, cpt);
                variant = lang.substring(cpt + 1);
                newlocale = new Locale(language, country, variant);
            }
        }
        return newlocale;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isStringInString(RuleBasedCollator rbc, String source, String target) {
        block28: {
            if (source == null || target == null) {
                return false;
            }
            if (source.length() == 0 && target.length() == 0) {
                return true;
            }
            strengthResult = 3;
            isFrenchSec = false;
            rbc.setDecomposition(2);
            rules = rbc.getRules();
            if (rules.startsWith("@")) {
                isFrenchSec = true;
            }
            sourceCursor = rbc.getCollationElementIterator(source);
            targetCursor = rbc.getCollationElementIterator(target);
            sOrder = 0;
            tOrder = 0;
            gets = true;
            gett = true;
            toffset = 0;
            block9: while (true) {
                block29: {
                    try {
                        sourceCursor.setOffset(0);
                    }
                    catch (NoSuchMethodError var22_23) {
                        // empty catch block
                    }
                    sOrder = sourceCursor.next();
                    try {
                        targetCursor.setOffset(toffset);
                    }
                    catch (NoSuchMethodError var22_24) {
                    }
                    catch (Exception e) {
                        return false;
                    }
                    tOrder = targetCursor.next();
                    if (tOrder != -1) ** GOTO lbl49
                    break block28;
lbl-1000:
                    // 1 sources

                    {
                        if (sOrder == tOrder) {
                            try {
                                toffset = targetCursor.getOffset();
                            }
                            catch (NoSuchMethodError var22_26) {}
                            break;
                        }
                        pSOrder = CollationElementIterator.primaryOrder(sOrder);
                        if (pSOrder == (pTOrder = CollationElementIterator.primaryOrder(tOrder))) {
                            try {
                                toffset = targetCursor.getOffset();
                            }
                            catch (NoSuchMethodError var22_27) {}
                            break;
                        }
                        tOrder = targetCursor.next();
lbl49:
                        // 2 sources

                        ** while (tOrder != -1)
                    }
lbl50:
                    // 5 sources

                    if (tOrder == -1) {
                        return false;
                    }
                    gets = false;
                    gett = false;
                    checkSecTer = initialCheckSecTer = rbc.getStrength() >= 1;
                    v0 = checkTertiary = rbc.getStrength() >= 2;
                    while (true) {
                        if (gets) {
                            sOrder = sourceCursor.next();
                        } else {
                            gets = true;
                        }
                        if (gett) {
                            tOrder = targetCursor.next();
                        } else {
                            gett = true;
                        }
                        if (sOrder == -1 || tOrder == -1) break block29;
                        pSOrder = CollationElementIterator.primaryOrder(sOrder);
                        pTOrder = CollationElementIterator.primaryOrder(tOrder);
                        if (sOrder == tOrder) {
                            if (!isFrenchSec || pSOrder == 0 || checkSecTer) continue;
                            checkSecTer = initialCheckSecTer;
                            checkTertiary = false;
                            continue;
                        }
                        if (pSOrder != pTOrder) {
                            if (sOrder == 0) {
                                gett = false;
                                continue;
                            }
                            if (tOrder == 0) {
                                gets = false;
                                continue;
                            }
                            if (pSOrder == 0) {
                                if (checkSecTer) continue block9;
                                gett = false;
                                continue;
                            }
                            if (pTOrder != 0 || checkSecTer) continue block9;
                            gets = false;
                            continue;
                        }
                        if (checkSecTer && ((secSOrder = CollationElementIterator.secondaryOrder(sOrder)) != (secTOrder = CollationElementIterator.secondaryOrder(tOrder)) || checkTertiary && (terSOrder = CollationElementIterator.tertiaryOrder(sOrder)) != (terTOrder = CollationElementIterator.tertiaryOrder(tOrder)))) break;
                    }
                    continue;
                }
                if (sOrder == -1) break;
                do {
                    if (!(CollationElementIterator.primaryOrder(sOrder) != 0 || CollationElementIterator.secondaryOrder(sOrder) != 0 && checkSecTer)) ** break;
                    continue block9;
                } while ((sOrder = sourceCursor.next()) != -1);
                break;
            }
            return true;
        }
        return false;
    }

    private static void debug(Object msg1, Object msg2, Object msg3) {
    }

    private static void debug(Object msg1) {
        HelpUtilities.debug(msg1, "", "");
    }

    private static void debug(Object msg1, Object msg2) {
        HelpUtilities.debug(msg1, msg2, "");
    }

    static class LocalePair {
        Locale locale1;
        Locale locale2;

        LocalePair(Locale locale1, Locale locale2) {
            this.locale1 = locale1;
            this.locale2 = locale2;
        }

        public int hashCode() {
            return this.locale1.hashCode() + this.locale2.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof LocalePair)) {
                return false;
            }
            LocalePair p = (LocalePair)obj;
            return this.locale1.equals(p.locale1) && this.locale2.equals(p.locale2);
        }
    }
}

