/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import com.sun.java.help.impl.LangElement;
import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import com.sun.java.help.impl.XmlReader;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.help.FlatMap;
import javax.help.HelpBroker;
import javax.help.HelpSetException;
import javax.help.HelpSetFactory;
import javax.help.HelpUtilities;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TryMap;
import javax.help.event.EventListenerList;
import javax.help.event.HelpSetEvent;
import javax.help.event.HelpSetListener;

public class HelpSet {
    protected EventListenerList listenerList = new EventListenerList();
    public static final String publicIDString = "-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 1.0//EN";
    public static final Object implRegistry;
    public static final String helpBrokerClass = "helpBroker/class";
    public static final String helpBrokerLoader = "helpBroker/loader";
    public static final Object kitTypeRegistry;
    public static final Object kitLoaderRegistry;
    private String title;
    private Map map;
    private TryMap combinedMap;
    private URL helpset;
    private String homeID;
    private Locale locale = Locale.getDefault();
    private ClassLoader loader;
    private Vector views = new Vector();
    private Vector helpsets;
    private static HelpBroker defaultHelpBroker;
    private Vector subHelpSets = new Vector();
    private static Hashtable defaultKeys;
    private Hashtable localKeys = new Hashtable();
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private static final boolean debug = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        ClassLoader cl;
        implRegistry = new StringBuffer("HelpSet.implRegistry");
        kitTypeRegistry = new StringBuffer("JHelpViewer.kitTypeRegistry");
        kitLoaderRegistry = new StringBuffer("JHelpViewer.kitLoaderRegistry");
        HelpSet.setDefaultKeyData(implRegistry, helpBrokerClass, "javax.help.DefaultHelpBroker");
        HelpSet.setDefaultKeyData(kitTypeRegistry, "text/html", "com.sun.java.help.impl.CustomKit");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.help.HelpSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cl = clazz.getClassLoader()) != null) {
            HelpSet.setDefaultKeyData(implRegistry, helpBrokerLoader, cl);
            HelpSet.setDefaultKeyData(kitLoaderRegistry, "text/html", cl);
        }
        defaultHelpBroker = null;
    }

    public HelpSet(ClassLoader loader) {
        this.helpsets = new Vector();
        this.loader = loader;
    }

    public HelpSet() {
        this.helpsets = new Vector();
        this.loader = null;
    }

    public HelpSet(ClassLoader loader, URL helpset) throws HelpSetException {
        this(loader);
        this.helpset = helpset;
        DefaultHelpSetFactory factory = new DefaultHelpSetFactory();
        this.parseInto(helpset, factory);
        HelpSet x = factory.parsingEnded(this);
        if (x == null) {
            throw new HelpSetException("Could not parse");
        }
    }

    public static URL findHelpSet(ClassLoader cl, String shortName, String extension, Locale locale) {
        return HelpUtilities.getLocalizedResource(cl, shortName, extension, locale, true);
    }

    public static URL findHelpSet(ClassLoader cl, String name, Locale locale) {
        String extension;
        String shortName;
        if (name.endsWith(".hs")) {
            shortName = name.substring(0, name.length() - 3);
            extension = ".hs";
        } else {
            shortName = name;
            extension = ".hs";
        }
        return HelpSet.findHelpSet(cl, shortName, extension, locale);
    }

    public static URL findHelpSet(ClassLoader cl, String name) {
        return HelpSet.findHelpSet(cl, name, Locale.getDefault());
    }

    public HelpBroker createHelpBroker() {
        HelpBroker back = null;
        String classname = (String)this.getKeyData(implRegistry, helpBrokerClass);
        ClassLoader loader = (ClassLoader)this.getKeyData(implRegistry, helpBrokerLoader);
        if (loader == null) {
            loader = this.getLoader();
        }
        try {
            Class<?> c = loader != null ? loader.loadClass(classname) : Class.forName(classname);
            back = (HelpBroker)c.newInstance();
        }
        catch (Throwable e) {
            back = null;
        }
        if (back != null) {
            back.setHelpSet(this);
        }
        return back;
    }

    public void add(HelpSet hs) {
        HelpSet.debug("add(" + hs + ")");
        this.helpsets.addElement(hs);
        this.fireHelpSetAdded(this, hs);
        this.combinedMap = null;
    }

    public boolean remove(HelpSet hs) {
        if (this.helpsets.removeElement(hs)) {
            this.fireHelpSetRemoved(this, hs);
            this.combinedMap = null;
            return true;
        }
        return false;
    }

    public Enumeration getHelpSets() {
        return this.helpsets.elements();
    }

    public boolean contains(HelpSet hs) {
        if (hs == this) {
            return true;
        }
        Enumeration e = this.helpsets.elements();
        while (e.hasMoreElements()) {
            HelpSet child = (HelpSet)e.nextElement();
            if (!child.contains(hs)) continue;
            return true;
        }
        return false;
    }

    public void addHelpSetListener(HelpSetListener l) {
        HelpSet.debug("addHelpSetListener(" + l + ")");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.help.event.HelpSetListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeHelpSetListener(HelpSetListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.help.event.HelpSetListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireHelpSetAdded(Object source, HelpSet helpset) {
        Object[] listeners = this.listenerList.getListenerList();
        HelpSetEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.help.event.HelpSetListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new HelpSetEvent(this, helpset, 0);
                }
                ((HelpSetListener)listeners[i + 1]).helpSetAdded(e);
            }
            i -= 2;
        }
    }

    protected void fireHelpSetRemoved(Object source, HelpSet helpset) {
        Object[] listeners = this.listenerList.getListenerList();
        HelpSetEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.help.event.HelpSetListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new HelpSetEvent(this, helpset, 1);
                }
                ((HelpSetListener)listeners[i + 1]).helpSetRemoved(e);
            }
            i -= 2;
        }
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.changes.firePropertyChange("title", oldTitle, title);
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(Locale l) {
        Locale oldLocale = this.locale;
        this.locale = l;
        this.changes.firePropertyChange("locale", oldLocale, this.locale);
    }

    public Map.ID getHomeID() {
        if (this.homeID == null) {
            return null;
        }
        try {
            return Map.ID.create(this.homeID, this);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setHomeID(String homeID) {
        String oldID = homeID;
        this.homeID = homeID;
        this.changes.firePropertyChange("homeID", oldID, homeID);
    }

    public Map getCombinedMap() {
        if (this.combinedMap == null) {
            this.combinedMap = new TryMap();
            this.combinedMap.add(this.map);
            Enumeration e = this.helpsets.elements();
            while (e.hasMoreElements()) {
                HelpSet hs = (HelpSet)e.nextElement();
                this.combinedMap.add(hs.getLocalMap());
            }
        }
        return this.combinedMap;
    }

    public Map getLocalMap() {
        return this.map;
    }

    public void setLocalMap(Map map) {
        this.map = map;
    }

    public URL getHelpSetURL() {
        return this.helpset;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public NavigatorView[] getNavigatorViews() {
        Object[] back = new NavigatorView[this.views.size()];
        this.views.copyInto(back);
        return back;
    }

    public NavigatorView getNavigatorView(String name) {
        HelpSet.debug("getNavigatorView(" + name + ")");
        int i = 0;
        while (i < this.views.size()) {
            NavigatorView view = (NavigatorView)this.views.elementAt(i);
            if (view.getName().equals(name)) {
                HelpSet.debug("  = " + view);
                return view;
            }
            ++i;
        }
        HelpSet.debug("  = null");
        return null;
    }

    public String toString() {
        return this.getTitle();
    }

    public static HelpSet parse(URL url, ClassLoader loader, HelpSetFactory factory) {
        HelpSet hs = new HelpSet(loader);
        hs.helpset = url;
        hs.parseInto(url, factory);
        return factory.parsingEnded(hs);
    }

    public void parseInto(URL url, HelpSetFactory factory) {
        try {
            URLConnection uc = url.openConnection();
            Reader src = XmlReader.createReader(uc);
            factory.parsingStarted(url);
            new HelpSetParser(factory).parseInto(src, this);
            src.close();
        }
        catch (Exception ex) {
            factory.reportMessage("Got an IOException (" + ex.getMessage() + ")", false);
            ex.printStackTrace();
        }
        int i = 0;
        while (i < this.subHelpSets.size()) {
            HelpSet subHS = (HelpSet)this.subHelpSets.elementAt(i);
            this.add(subHS);
            ++i;
        }
    }

    protected void addView(NavigatorView view) {
        this.views.addElement(view);
    }

    protected void addSubHelpSet(HelpSet hs) {
        this.subHelpSets.addElement(hs);
    }

    public Object getKeyData(Object context, String key) {
        Object back = null;
        Hashtable h = (Hashtable)this.localKeys.get(context);
        if (h != null) {
            back = h.get(key);
        }
        if (back == null && (h = (Hashtable)defaultKeys.get(context)) != null) {
            back = h.get(key);
        }
        return back;
    }

    public void setKeyData(Object context, String key, Object data) {
        Hashtable<String, Object> h = (Hashtable<String, Object>)this.localKeys.get(context);
        if (h == null) {
            h = new Hashtable<String, Object>();
            this.localKeys.put(context, h);
        }
        h.put(key, data);
    }

    private static void setDefaultKeyData(Object context, String key, Object data) {
        Hashtable<String, Object> h;
        if (defaultKeys == null) {
            defaultKeys = new Hashtable();
        }
        if ((h = (Hashtable<String, Object>)defaultKeys.get(context)) == null) {
            h = new Hashtable<String, Object>();
            defaultKeys.put(context, h);
        }
        h.put(key, data);
    }

    private static void debug(String str) {
    }

    public static class DefaultHelpSetFactory
    implements HelpSetFactory {
        private Vector messages = new Vector();
        private URL source;
        private boolean validParse = true;

        public void parsingStarted(URL source) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            this.source = source;
        }

        public void processDOCTYPE(String root, String publicID, String systemID) {
            if (publicID == null || !publicID.equals(HelpSet.publicIDString)) {
                this.parsingError("helpset.wrongPublicID", publicID);
            }
        }

        public void processPI(HelpSet hs, String target, String data) {
        }

        public void processTitle(HelpSet hs, String value) {
            String title = hs.getTitle();
            if (title != null && !title.equals("")) {
                this.parsingWarning("helpset.wrongTitle", value, title);
            }
            hs.setTitle(value);
        }

        public void processHomeID(HelpSet hs, String value) {
            Map.ID homeID = hs.getHomeID();
            if (homeID != null && !homeID.equals("")) {
                this.parsingError("helpset.wrongHomeID", value, homeID.id);
            }
            hs.setHomeID(value);
        }

        public void processMapRef(HelpSet hs, Hashtable attributes) {
            String spec = (String)attributes.get("location");
            URL hsURL = hs.getHelpSetURL();
            try {
                FlatMap map = new FlatMap(new URL(hsURL, spec), hs);
                Map omap = hs.getLocalMap();
                if (omap == null) {
                    hs.setLocalMap(map);
                } else {
                    this.parsingError("helpset.oneMapOnly");
                }
            }
            catch (MalformedURLException ee) {
                this.parsingError("helpset.malformedURL", spec);
            }
            catch (IOException ee) {
                this.parsingError("helpset.incorrectURL", spec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void processView(HelpSet hs, String name, String label, String type, Hashtable viewAttributes, String data, Hashtable dataAttributes, Locale locale) {
            try {
                NavigatorView view;
                if (data != null) {
                    if (dataAttributes == null) {
                        dataAttributes = new Hashtable<String, String>();
                    }
                    dataAttributes.put("data", data);
                }
                if ((view = NavigatorView.create(hs, name, label, locale, type, dataAttributes)) != null) {
                    hs.addView(view);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void processSubHelpSet(HelpSet hs, Hashtable attributes) {
            HelpSet.debug("createSubHelpSet");
            String spec = (String)attributes.get("location");
            URL base = hs.getHelpSetURL();
            HelpSet.debug("  location: " + spec);
            HelpSet.debug("  base helpset: " + base);
            URL u = null;
            HelpSet subHS = null;
            try {
                u = new URL(base, spec);
                InputStream is = u.openStream();
                if (is != null && (subHS = new HelpSet(hs.getLoader(), u)) != null) {
                    hs.addSubHelpSet(subHS);
                }
            }
            catch (MalformedURLException is) {
            }
            catch (IOException is) {
            }
            catch (HelpSetException ex) {
                this.parsingError("helpset.subHelpSetTrouble", spec);
            }
        }

        public void reportMessage(String msg, boolean validParse) {
            this.messages.addElement(msg);
            this.validParse = this.validParse && validParse;
        }

        public Enumeration listMessages() {
            return this.messages.elements();
        }

        public HelpSet parsingEnded(HelpSet hs) {
            HelpSet back = hs;
            if (!this.validParse) {
                back = null;
                System.err.println("Parsing failed for " + this.source);
                Enumeration e = this.messages.elements();
                while (e.hasMoreElements()) {
                    String msg = (String)e.nextElement();
                    System.err.println(msg);
                }
            }
            return back;
        }

        private void parsingError(String key) {
            String s = HelpUtilities.getText(key);
            this.reportMessage(s, false);
        }

        private void parsingError(String key, String s) {
            String msg = HelpUtilities.getText(key, s);
            this.reportMessage(msg, false);
        }

        private void parsingError(String key, String s1, String s2) {
            String msg = HelpUtilities.getText(key, s1, s2);
            this.reportMessage(msg, false);
        }

        private void parsingWarning(String key, String s1, String s2) {
            String msg = HelpUtilities.getText(key, s1, s2);
            this.reportMessage(msg, true);
        }
    }

    private static class HelpSetParser
    implements ParserListener {
        private Stack tagStack;
        private Locale defaultLocale;
        private Locale lastLocale;
        private HelpSet myHS;
        private Locale myHSLocale;
        private HelpSetFactory factory;
        private String viewName;
        private String viewLabel;
        private String viewType;
        private String viewEngine;
        private String viewData;
        private Hashtable htData;

        HelpSetParser(HelpSetFactory factory) {
            this.factory = factory;
        }

        synchronized void parseInto(Reader src, HelpSet hs) throws IOException {
            this.tagStack = new Stack();
            this.lastLocale = this.defaultLocale = hs.getLocale();
            this.myHS = hs;
            this.myHSLocale = hs.getLocale();
            Parser parser = new Parser(src);
            parser.addParserListener(this);
            parser.parse();
        }

        public void tagFound(ParserEvent e) {
            Hashtable ht;
            Locale locale = null;
            Tag tag = e.getTag();
            String name = tag.name;
            TagProperties attr = tag.atts;
            Hashtable hashtable = ht = attr == null ? null : attr.getHashtable();
            if (attr != null) {
                String lang = attr.getProperty("xml:lang");
                locale = HelpUtilities.localeFromLang(lang);
            }
            if (locale == null) {
                locale = this.lastLocale;
            }
            if (name.equals("helpset")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    String version;
                    if (!locale.equals(this.defaultLocale) && !locale.equals(this.myHSLocale) && locale != null) {
                        this.myHS.setLocale(locale);
                        this.defaultLocale = locale;
                    }
                    if (attr != null && (version = attr.getProperty("version")) != null && version.compareTo("1.0") != 0) {
                        this.parsingError("helpset.unknownVersion", version);
                    }
                    this.addTag(tag, locale);
                }
                return;
            }
            if (this.tagStack.empty()) {
                this.parsingError("helpset.wrongTopLevel", name);
            }
            LangElement le = (LangElement)this.tagStack.peek();
            String pname = le.getTag().name;
            if (name.equals("title")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!pname.equals("helpset")) {
                        this.wrongParent(name, pname);
                    }
                    if (!locale.equals(this.defaultLocale) && !locale.equals(this.myHSLocale)) {
                        this.wrongLocale(locale, this.defaultLocale, this.myHSLocale);
                    }
                    this.addTag(tag, locale);
                }
            } else if (name.equals("homeID")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!pname.equals("maps")) {
                        this.wrongParent(name, pname);
                    }
                    this.addTag(tag, locale);
                }
            } else if (name.equals("mapref")) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else {
                    if (!pname.equals("maps")) {
                        this.wrongParent(name, pname);
                    }
                    if (!tag.isEmpty) {
                        this.addTag(tag, locale);
                    }
                    this.factory.processMapRef(this.myHS, ht);
                }
            } else if (name.equals("data")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else {
                    if (!pname.equals("view")) {
                        this.wrongParent(name, pname);
                    } else {
                        this.addTag(tag, locale);
                    }
                    this.htData = ht;
                }
            } else if (name.equals("name") || name.equals("type")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!pname.equals("view")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (name.equals("label")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!pname.equals("view")) {
                    this.wrongParent(name, pname);
                } else {
                    if (!locale.equals(this.defaultLocale) && !locale.equals(this.myHSLocale)) {
                        this.wrongLocale(locale, this.defaultLocale, this.myHSLocale);
                    }
                    this.addTag(tag, locale);
                }
            } else if (name.equals("view")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                    this.factory.processView(this.myHS, this.viewName, this.viewLabel, this.viewType, ht, this.viewData, this.htData, locale);
                } else if (!pname.equals("helpset")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (name.equals("maps")) {
                if (tag.isEnd) {
                    this.removeTag(tag);
                } else if (!pname.equals("helpset")) {
                    this.wrongParent(name, pname);
                } else {
                    this.addTag(tag, locale);
                }
            } else if (name.equals("subhelpset")) {
                if (tag.isEnd && !tag.isEmpty) {
                    this.removeTag(tag);
                } else {
                    if (!tag.isEmpty) {
                        this.addTag(tag, locale);
                    }
                    this.factory.processSubHelpSet(this.myHS, ht);
                }
            }
        }

        public void piFound(ParserEvent e) {
            this.factory.processPI(this.myHS, e.getTarget(), e.getData());
        }

        public void doctypeFound(ParserEvent e) {
            this.factory.processDOCTYPE(e.getRoot(), e.getPublicId(), e.getSystemId());
        }

        private void checkNull(String name, String t) {
            if (!t.equals("")) {
                this.parsingError("helpset.wrongText", name, t);
            }
        }

        public void textFound(ParserEvent e) {
            HelpSet.debug("textFound: ");
            HelpSet.debug("  text: " + e.getText());
            if (this.tagStack.empty()) {
                return;
            }
            LangElement le = (LangElement)this.tagStack.peek();
            Tag tag = le.getTag();
            TagProperties attr = tag.atts;
            Hashtable ht = attr == null ? null : attr.getHashtable();
            String text = e.getText().trim();
            String name = tag.name;
            if (name.equals("helpset")) {
                this.checkNull("helpset", text);
                return;
            }
            int depth = this.tagStack.size();
            String pname = "";
            if (depth >= 2) {
                le = (LangElement)this.tagStack.elementAt(depth - 2);
                pname = le.getTag().name;
            }
            if (name.equals("title")) {
                this.factory.processTitle(this.myHS, text);
            } else if (name.equals("homeID")) {
                this.factory.processHomeID(this.myHS, text);
            } else if (name.equals("mapref")) {
                this.checkNull("mapref", text);
            } else if (name.equals("subhelpset")) {
                this.checkNull("subhelpset", text);
            } else if (name.equals("data")) {
                this.viewData = text.trim();
            } else if (name.equals("label")) {
                this.viewLabel = text.trim();
            } else if (name.equals("name")) {
                this.viewName = text.trim();
            } else if (name.equals("type")) {
                this.viewType = text.trim();
            } else if (name.equals("view")) {
                this.checkNull("view", text);
            } else if (name.equals("maps")) {
                this.checkNull("maps", text);
            }
        }

        public void errorFound(ParserEvent e) {
        }

        public void commentFound(ParserEvent e) {
        }

        protected void addTag(Tag tag, Locale locale) {
            LangElement el = new LangElement(tag, locale);
            this.tagStack.push(el);
            if (this.lastLocale == null) {
                this.lastLocale = locale;
                return;
            }
            if (locale == null) {
                this.lastLocale = locale;
                return;
            }
            if (!this.lastLocale.equals(locale)) {
                this.lastLocale = locale;
            }
        }

        protected void removeTag(Tag tag) {
            LangElement el;
            String name = tag.name;
            Locale newLocale = null;
            do {
                if (this.tagStack.empty()) {
                    this.unbalanced(name);
                }
                el = (LangElement)this.tagStack.pop();
            } while (!el.getTag().name.equals(name));
            if (this.tagStack.empty()) {
                newLocale = this.defaultLocale;
            } else {
                el = (LangElement)this.tagStack.peek();
                newLocale = el.getLocale();
            }
            if (this.lastLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (newLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (!this.lastLocale.equals(newLocale)) {
                this.lastLocale = newLocale;
            }
        }

        private void parsingError(String key) {
            String s = HelpUtilities.getText(key);
            this.factory.reportMessage(s, false);
        }

        private void parsingError(String key, String s) {
            String msg = HelpUtilities.getText(key, s);
            this.factory.reportMessage(msg, false);
        }

        private void parsingError(String key, String s1, String s2) {
            String msg = HelpUtilities.getText(key, s1, s2);
            this.factory.reportMessage(msg, false);
        }

        private void wrongParent(String name, String pname) {
            this.parsingError("helpset.wrongParent", name, pname);
        }

        private void unbalanced(String name) {
            this.parsingError("helpset.unbalanced", name);
        }

        private void wrongLocale(Locale found, Locale l1, Locale l2) {
            String msg = HelpUtilities.getText("helpset.wrongLocale", found.toString(), l1.toString(), l2.toString());
            this.factory.reportMessage(msg, true);
        }
    }
}

