/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.UnsupportedOperationException;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class DefaultHelpBroker
implements HelpBroker,
KeyListener {
    protected HelpSet helpset = null;
    protected JFrame frame = null;
    protected JHelp jhelp = null;
    protected Locale locale = null;
    protected Font font = null;
    protected JDialog dialog = null;
    protected Window ownerWindow = null;
    protected boolean modallyActivated = false;
    static boolean on1dot1 = true;
    private int HELP_WIDTH = 645;
    private int HELP_HEIGHT = 495;
    WindowListener dl;
    boolean modalDeactivated = true;
    protected ActionListener displayHelpFromFocus;
    protected ActionListener displayHelpFromSource;
    private static final boolean debug = false;
    private boolean lastModallyActivated = !this.modallyActivated;
    protected Image frameIcon;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        try {
            Constructor k;
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.awt.Dialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            classArray[1] = Boolean.TYPE;
            Class[] types = classArray;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("javax.swing.JDialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            on1dot1 = (k = clazz2.getConstructor(types)) == null;
        }
        catch (NoSuchMethodException e) {
            on1dot1 = true;
        }
        HelpUtilities.installLookAndFeelDefaults();
    }

    public DefaultHelpBroker() {
    }

    public DefaultHelpBroker(HelpSet hs) {
        this.setHelpSet(hs);
    }

    private synchronized void createHelpWindow() {
        DefaultHelpBroker.debug("createHelpWindow");
        this.createJHelp();
        String helpTitle = this.helpset.getTitle();
        if (this.modallyActivated != this.lastModallyActivated) {
            Point pos = null;
            Dimension size = null;
            JDialog tmpDialog = null;
            if (this.modallyActivated) {
                Window owner = null;
                try {
                    Method m;
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = class$3 = Class.forName("java.awt.Window");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((m = clazz.getMethod("getOwner", null)) != null && this.dialog != null) {
                        owner = (Window)m.invoke((Object)this.dialog, null);
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (this.dialog == null || owner != this.ownerWindow || this.modalDeactivated) {
                    if (this.frame != null) {
                        pos = this.frame.getLocation();
                        size = this.frame.getSize();
                        this.frame.dispose();
                    }
                    if (this.dialog != null) {
                        pos = this.dialog.getLocation();
                        size = this.dialog.getSize();
                        tmpDialog = this.dialog;
                    }
                    if (on1dot1) {
                        this.dialog = new JDialog();
                        this.dialog.setTitle(helpTitle);
                    } else {
                        this.dialog = new JDialog((Dialog)this.ownerWindow, helpTitle);
                        this.dl = new WindowAdapter(){

                            public void windowClosing(WindowEvent e) {
                                DefaultHelpBroker.debug("modal window closing");
                                if (DefaultHelpBroker.this.dialog.isShowing()) {
                                    DefaultHelpBroker.this.dialog.hide();
                                }
                                DefaultHelpBroker.this.ownerWindow.removeWindowListener(DefaultHelpBroker.this.dl);
                                DefaultHelpBroker.this.ownerWindow = null;
                                DefaultHelpBroker.this.modalDeactivated = true;
                            }
                        };
                        DefaultHelpBroker.debug("adding windowlistener");
                        this.ownerWindow.addWindowListener(this.dl);
                        this.modalDeactivated = false;
                    }
                    if (size != null) {
                        ((Component)this.dialog).setSize(size);
                    } else {
                        ((Component)this.dialog).setSize(this.HELP_WIDTH, this.HELP_HEIGHT);
                    }
                    if (pos != null) {
                        ((Component)this.dialog).setLocation(pos);
                    }
                    this.dialog.getContentPane().add(this.jhelp);
                    if (tmpDialog != null) {
                        tmpDialog.dispose();
                    }
                }
            } else {
                if (this.frame == null) {
                    this.frame = new JFrame(helpTitle);
                    WindowAdapter l = new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            ((Component)DefaultHelpBroker.this.frame).setVisible(false);
                        }

                        public void windowClosed(WindowEvent e) {
                            ((Component)DefaultHelpBroker.this.frame).setVisible(false);
                        }
                    };
                    this.frame.addWindowListener(l);
                }
                if (this.dialog != null) {
                    pos = this.dialog.getLocation();
                    size = this.dialog.getSize();
                    this.dialog.dispose();
                    this.dialog = null;
                    this.ownerWindow = null;
                }
                if (size != null) {
                    ((Component)this.frame).setSize(size);
                } else {
                    ((Component)this.frame).setSize(this.HELP_WIDTH, this.HELP_HEIGHT);
                }
                if (pos != null) {
                    ((Component)this.frame).setLocation(pos);
                }
                this.frame.getContentPane().add(this.jhelp);
            }
            this.lastModallyActivated = this.modallyActivated;
        }
    }

    private synchronized void createJHelp() {
        DefaultHelpBroker.debug("createJHelp");
        if (this.jhelp == null) {
            this.jhelp = new JHelp(this.helpset);
            if (this.font != null) {
                this.jhelp.setFont(this.font);
            }
            if (this.locale != null) {
                this.jhelp.setLocale(this.locale);
            }
        }
    }

    private static void debug(Object msg) {
    }

    public void enableHelp(Component comp, String id, HelpSet hs) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
    }

    public void enableHelp(MenuItem comp, String id, HelpSet hs) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
    }

    public void enableHelpKey(Component comp, String id, HelpSet hs) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
        if (comp instanceof JComponent) {
            JComponent root = (JComponent)comp;
            root.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(156, 0), 2);
            root.registerKeyboardAction(this.getDisplayHelpFromFocus(), KeyStroke.getKeyStroke(112, 0), 2);
        } else {
            comp.addKeyListener(this);
        }
    }

    public void enableHelpOnButton(Component comp, String id, HelpSet hs) {
        if (!(comp instanceof AbstractButton) && !(comp instanceof Button)) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
        if (comp instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)comp;
            button.addActionListener(this.getDisplayHelpFromSource());
        } else if (comp instanceof Button) {
            Button button = (Button)comp;
            button.addActionListener(this.getDisplayHelpFromSource());
        }
    }

    public void enableHelpOnButton(MenuItem comp, String id, HelpSet hs) {
        if (comp == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        CSH.setHelpIDString(comp, id);
        if (hs != null) {
            CSH.setHelpSet(comp, hs);
        }
        comp.addActionListener(this.getDisplayHelpFromSource());
    }

    public Map.ID getCurrentID() {
        if (this.jhelp != null) {
            return this.jhelp.getModel().getCurrentID();
        }
        return null;
    }

    public URL getCurrentURL() {
        return this.jhelp.getModel().getCurrentURL();
    }

    public String getCurrentView() {
        this.createHelpWindow();
        return this.jhelp.getCurrentNavigator().getNavigatorName();
    }

    protected ActionListener getDisplayHelpFromFocus() {
        if (this.displayHelpFromFocus == null) {
            this.displayHelpFromFocus = new CSH.DisplayHelpFromFocus(this);
        }
        return this.displayHelpFromFocus;
    }

    protected ActionListener getDisplayHelpFromSource() {
        if (this.displayHelpFromSource == null) {
            this.displayHelpFromSource = new CSH.DisplayHelpFromSource(this);
        }
        return this.displayHelpFromSource;
    }

    public Font getFont() {
        this.createHelpWindow();
        if (this.font == null) {
            return this.jhelp.getFont();
        }
        return this.font;
    }

    public HelpSet getHelpSet() {
        return this.helpset;
    }

    public Image getIconImage() {
        return this.frameIcon;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public Point getLocation() throws UnsupportedOperationException {
        if (this.jhelp == null) {
            throw new IllegalComponentStateException("presentation not displayed");
        }
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.getLocation();
            }
        } else if (this.frame != null) {
            return this.frame.getLocation();
        }
        return null;
    }

    public Dimension getSize() throws UnsupportedOperationException {
        if (this.jhelp == null) {
            throw new IllegalComponentStateException("presentation not displayed");
        }
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.getSize();
            }
        } else if (this.frame != null) {
            return this.frame.getSize();
        }
        return null;
    }

    public void initPresentation() {
        this.createHelpWindow();
    }

    public boolean isDisplayed() {
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.isShowing();
            }
            return false;
        }
        if (this.frame != null) {
            if (!this.frame.isVisible()) {
                return false;
            }
            try {
                Method m;
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.awt.Frame");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((m = clazz.getMethod("getState", null)) != null) {
                    int value = (Integer)m.invoke((Object)this.frame, null);
                    return value == 0;
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean isViewDisplayed() {
        this.createHelpWindow();
        return this.jhelp.isNavigatorDisplayed();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 112 || code == 156) {
            ActionListener al = this.getDisplayHelpFromFocus();
            al.actionPerformed(new ActionEvent(e.getComponent(), 1001, null));
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setActivationWindow(Window window) {
        if (window != null && window instanceof Dialog) {
            Dialog tmpDialog = (Dialog)window;
            if (tmpDialog.isModal()) {
                if (window != this.ownerWindow) {
                    System.out.println("windowChanged");
                    this.lastModallyActivated = false;
                }
                this.ownerWindow = window;
                this.modallyActivated = true;
            } else {
                this.ownerWindow = null;
                this.modallyActivated = false;
            }
        } else {
            this.ownerWindow = null;
            this.modallyActivated = false;
        }
    }

    public void setCurrentID(String id) throws BadIDException {
        try {
            this.setCurrentID(Map.ID.create(id, this.helpset));
        }
        catch (InvalidHelpSetContextException ex) {
            new Error("internal error?");
        }
    }

    public void setCurrentID(Map.ID id) throws InvalidHelpSetContextException {
        DefaultHelpBroker.debug("setCurrentID");
        this.createJHelp();
        this.jhelp.getModel().setCurrentID(id);
    }

    public void setCurrentURL(URL url) {
        this.createHelpWindow();
        this.jhelp.getModel().setCurrentURL(url);
        if (this.modallyActivated) {
            ((Component)this.dialog).setVisible(true);
            this.dialog.show();
        } else {
            ((Component)this.frame).setVisible(true);
            this.frame.show();
        }
    }

    public void setCurrentView(String name) {
        this.createHelpWindow();
        JHelpNavigator nav = null;
        Enumeration e = this.jhelp.getHelpNavigators();
        while (e.hasMoreElements()) {
            nav = (JHelpNavigator)e.nextElement();
            if (nav.getNavigatorName().equals(name)) break;
            nav = null;
        }
        if (nav == null) {
            throw new IllegalArgumentException("Invalid view name");
        }
        this.jhelp.setCurrentNavigator(nav);
    }

    public void setDisplayed(boolean b) {
        DefaultHelpBroker.debug("setDisplayed");
        this.createHelpWindow();
        if (this.modallyActivated) {
            if (b) {
                this.dialog.show();
            } else {
                this.dialog.hide();
            }
        } else {
            ((Frame)this.frame).setIconImage(this.getIconImage());
            ((Component)this.frame).setVisible(b);
            try {
                Method m;
                Class[] types = new Class[]{Integer.TYPE};
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.awt.Frame");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((m = clazz.getMethod("setState", types)) != null) {
                    Object[] args = new Object[]{new Integer(0)};
                    m.invoke((Object)this.frame, args);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public void setFont(Font f) {
        this.font = f;
        if (this.jhelp != null) {
            this.jhelp.setFont(this.font);
        }
    }

    public void setHelpSet(HelpSet hs) {
        if (hs != null && this.helpset != hs) {
            if (this.jhelp != null) {
                DefaultHelpModel model = new DefaultHelpModel(hs);
                this.jhelp.setModel(model);
            }
            this.helpset = hs;
        }
    }

    public void setIconImage(Image newIcon) {
        this.frameIcon = newIcon;
    }

    public void setLocale(Locale l) {
        this.locale = l;
        if (this.jhelp != null) {
            this.jhelp.setLocale(this.locale);
        }
    }

    public void setLocation(Point p) throws UnsupportedOperationException {
        this.createHelpWindow();
        if (this.modallyActivated) {
            ((Component)this.dialog).setLocation(p);
        } else {
            ((Component)this.frame).setLocation(p);
        }
    }

    public void setSize(Dimension d) throws UnsupportedOperationException {
        this.HELP_WIDTH = d.width;
        this.HELP_HEIGHT = d.height;
        this.createHelpWindow();
        if (this.modallyActivated) {
            ((Component)this.dialog).setSize(d);
            this.dialog.validate();
        } else {
            ((Component)this.frame).setSize(d);
            this.frame.validate();
        }
    }

    public void setViewDisplayed(boolean displayed) {
        this.createHelpWindow();
        this.jhelp.setNavigatorDisplayed(displayed);
    }
}

