/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Stack;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CSH {
    private static Hashtable comps;
    private static final boolean debug = false;

    private static void debug(Object msg) {
    }

    private static void dispatchEvent(Object src, AWTEvent event) {
        if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        }
    }

    private static Component findComponentAt(Container cont, int x, int y) {
        if (!cont.contains(x, y)) {
            return null;
        }
        int ncomponents = cont.getComponentCount();
        Component[] component = cont.getComponents();
        int i = 0;
        while (i < ncomponents) {
            Component comp = component[i];
            if (comp != null && comp.isVisible()) {
                Point compp = comp.getLocation();
                if ((comp = comp instanceof Container ? CSH.findComponentAt((Container)comp, x - compp.x, y - compp.y) : comp.locate(x - compp.x, y - compp.y)) != null && comp.isVisible()) {
                    return comp;
                }
            }
            ++i;
        }
        return cont;
    }

    private static Object getDeepestObjectAt(Object parent, int x, int y) {
        Component child;
        if (parent != null && parent instanceof Container && (child = CSH.findComponentAt((Container)parent, x, y)) != null && child != parent) {
            if (child instanceof JRootPane) {
                JLayeredPane lp = ((JRootPane)child).getLayeredPane();
                Rectangle b = lp.getBounds();
                child = (Component)CSH.getDeepestObjectAt(lp, x - b.x, y - b.y);
                if (child != null) {
                    return child;
                }
            } else {
                return child;
            }
        }
        return parent;
    }

    public static String getHelpIDString(Component comp) {
        Hashtable clientProps;
        String helpID = null;
        if (comp instanceof JComponent) {
            helpID = (String)((JComponent)comp).getClientProperty("HelpID");
        } else if (comps != null && (clientProps = (Hashtable)comps.get(comp)) != null) {
            helpID = (String)clientProps.get("HelpID");
        }
        if (helpID != null) {
            return helpID;
        }
        Container parent = comp.getParent();
        if (parent != null) {
            return CSH.getHelpIDString(parent);
        }
        return null;
    }

    public static String getHelpIDString(MenuItem comp) {
        Hashtable clientProps;
        String helpID = null;
        if (comps != null && (clientProps = (Hashtable)comps.get(comp)) != null) {
            helpID = (String)clientProps.get("HelpID");
        }
        if (helpID != null) {
            return helpID;
        }
        MenuContainer parent = comp.getParent();
        if (parent != null && parent instanceof MenuItem) {
            return CSH.getHelpIDString((MenuItem)((Object)parent));
        }
        return null;
    }

    public static HelpSet getHelpSet(Component comp) {
        Hashtable clientProps;
        String helpID = null;
        HelpSet hs = null;
        if (comp instanceof JComponent) {
            helpID = (String)((JComponent)comp).getClientProperty("HelpID");
            if (helpID != null) {
                hs = (HelpSet)((JComponent)comp).getClientProperty("HelpSet");
            }
        } else if (comps != null && (clientProps = (Hashtable)comps.get(comp)) != null && (helpID = (String)clientProps.get("HelpID")) != null) {
            hs = (HelpSet)clientProps.get("HelpSet");
        }
        if (helpID != null) {
            return hs;
        }
        Container parent = comp.getParent();
        if (parent != null) {
            return CSH.getHelpSet(parent);
        }
        return null;
    }

    public static HelpSet getHelpSet(MenuItem comp) {
        Hashtable clientProps;
        String helpID = null;
        HelpSet hs = null;
        if (comps != null && (clientProps = (Hashtable)comps.get(comp)) != null && (helpID = (String)clientProps.get("HelpID")) != null) {
            hs = (HelpSet)clientProps.get("HelpSet");
        }
        if (helpID != null) {
            return hs;
        }
        MenuContainer parent = comp.getParent();
        if (parent != null && parent instanceof MenuItem) {
            return CSH.getHelpSet((MenuItem)((Object)parent));
        }
        return null;
    }

    public static void setHelpIDString(Component comp, String helpID) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).putClientProperty("HelpID", helpID);
        } else {
            Hashtable<String, String> clientProps;
            if (comps == null) {
                comps = new Hashtable(5);
            }
            if ((clientProps = (Hashtable<String, String>)comps.get(comp)) != null) {
                if (helpID != null) {
                    clientProps.put("HelpID", helpID);
                } else {
                    clientProps.remove(helpID);
                }
            } else if (helpID != null) {
                clientProps = new Hashtable<String, String>(2);
                clientProps.put("HelpID", helpID);
                comps.put(comp, clientProps);
            }
        }
    }

    public static void setHelpIDString(MenuItem comp, String helpID) {
        Hashtable<String, String> clientProps;
        if (comps == null) {
            comps = new Hashtable(5);
        }
        if ((clientProps = (Hashtable<String, String>)comps.get(comp)) != null) {
            if (helpID != null) {
                clientProps.put("HelpID", helpID);
            } else {
                clientProps.remove(helpID);
            }
        } else if (helpID != null) {
            clientProps = new Hashtable<String, String>(2);
            clientProps.put("HelpID", helpID);
            comps.put(comp, clientProps);
        }
    }

    public static void setHelpSet(Component comp, HelpSet hs) {
        if (comp == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (comp instanceof JComponent) {
            ((JComponent)comp).putClientProperty("HelpSet", hs);
        } else {
            Hashtable<String, HelpSet> clientProps;
            if (comps == null) {
                comps = new Hashtable(5);
            }
            if ((clientProps = (Hashtable<String, HelpSet>)comps.get(comp)) != null) {
                if (hs != null) {
                    clientProps.put("HelpSet", hs);
                } else {
                    clientProps.remove(hs);
                }
            } else if (hs != null) {
                clientProps = new Hashtable<String, HelpSet>(2);
                clientProps.put("HelpSet", hs);
                comps.put(comp, clientProps);
            }
        }
    }

    public static void setHelpSet(MenuItem comp, HelpSet hs) {
        Hashtable<String, HelpSet> clientProps;
        if (comps == null) {
            comps = new Hashtable(5);
        }
        if ((clientProps = (Hashtable<String, HelpSet>)comps.get(comp)) != null) {
            if (hs != null) {
                clientProps.put("HelpSet", hs);
            } else {
                clientProps.remove(hs);
            }
        } else if (hs != null) {
            clientProps = new Hashtable<String, HelpSet>(2);
            clientProps.put("HelpSet", hs);
            comps.put(comp, clientProps);
        }
    }

    public static Object trackCSEvents() {
        block28: {
            try {
                EventQueue eq;
                if (!Thread.currentThread().getClass().getName().endsWith("EventDispatchThread")) break block28;
                try {
                    eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (Exception ee) {
                    return null;
                }
                if (eq == null) {
                    return null;
                }
                while (true) {
                    InputEvent e;
                    AWTEvent event = eq.getNextEvent();
                    Object src = event.getSource();
                    try {
                        Class<?> kActiveEvent = Class.forName("java.awt.ActiveEvent");
                        if (kActiveEvent != null && kActiveEvent.isInstance(event)) {
                            Method m = null;
                            Class[] types = new Class[]{};
                            Object[] args = new Object[]{};
                            m = kActiveEvent.getMethod("dispatch", types);
                            if (m != null) {
                                m.invoke((Object)event, args);
                                continue;
                            }
                        }
                    }
                    catch (NoSuchMethodError kActiveEvent) {
                    }
                    catch (ClassNotFoundException kActiveEvent) {
                    }
                    catch (IllegalAccessException kActiveEvent) {
                    }
                    catch (InvocationTargetException kActiveEvent) {
                    }
                    catch (NoSuchMethodException kActiveEvent) {
                        // empty catch block
                    }
                    if (src instanceof Component) {
                        if (event instanceof InputEvent) {
                            if (event instanceof KeyEvent) {
                                e = (KeyEvent)event;
                                if (((KeyEvent)e).getKeyCode() == 3) {
                                    e.consume();
                                    return null;
                                }
                                CSH.dispatchEvent(src, event);
                                continue;
                            }
                            if (event instanceof MouseEvent) {
                                e = (MouseEvent)event;
                                int eID = e.getID();
                                if (eID == 500 || eID == 501 || eID == 502) {
                                    if (eID == 502) {
                                        e.consume();
                                        return CSH.getDeepestObjectAt(src, ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
                                    }
                                    e.consume();
                                    continue;
                                }
                                e.consume();
                                continue;
                            }
                            CSH.dispatchEvent(src, event);
                            continue;
                        }
                        CSH.dispatchEvent(src, event);
                        continue;
                    }
                    if (src instanceof MenuComponent) {
                        if (src instanceof MenuItem) {
                            if (!(event instanceof InputEvent)) continue;
                            if (event instanceof KeyEvent) {
                                e = (KeyEvent)event;
                                if (((KeyEvent)e).getKeyCode() == 3) {
                                    e.consume();
                                    return null;
                                }
                                CSH.dispatchEvent(src, event);
                                continue;
                            }
                            if (event instanceof MouseEvent) {
                                e = (MouseEvent)event;
                                int eID = e.getID();
                                if (eID == 500 || eID == 501 || eID == 502) {
                                    if (eID == 502) {
                                        e.consume();
                                        return CSH.getDeepestObjectAt(src, ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
                                    }
                                    e.consume();
                                    continue;
                                }
                                e.consume();
                                continue;
                            }
                            CSH.dispatchEvent(src, event);
                            continue;
                        }
                        CSH.dispatchEvent(src, event);
                        continue;
                    }
                    System.err.println("unable to dispatch event: " + event);
                }
            }
            catch (InterruptedException e) {
                CSH.debug("InterrupedExeception");
            }
        }
        CSH.debug("Fall Through code");
        return null;
    }

    public static class DisplayHelpFromFocus
    implements ActionListener {
        private HelpBroker hb;

        public DisplayHelpFromFocus(HelpBroker hb) {
            if (hb == null) {
                throw new NullPointerException("hb");
            }
            this.hb = hb;
        }

        public void actionPerformed(ActionEvent e) {
            Component comp;
            Component src = (Component)e.getSource();
            try {
                Window owner = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), src);
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow(owner);
                }
            }
            catch (ClassNotFoundException owner) {
                // empty catch block
            }
            if ((comp = SwingUtilities.findFocusOwner(src)) == null) {
                comp = src;
            }
            String helpID = CSH.getHelpIDString(comp);
            HelpSet hs = CSH.getHelpSet(comp);
            if (hs == null) {
                hs = this.hb.getHelpSet();
            }
            try {
                Map.ID id = null;
                try {
                    id = Map.ID.create(helpID, hs);
                }
                catch (BadIDException bide) {
                    System.err.println(bide);
                }
                if (id == null) {
                    id = hs.getHomeID();
                }
                this.hb.setCurrentID(id);
                this.hb.setDisplayed(true);
            }
            catch (Exception e2) {
                System.err.print("Trouble in CSH$DisplayHelpFromFocus.actionPerformed()");
            }
        }
    }

    public static class DisplayHelpAfterTracking
    implements ActionListener {
        private HelpBroker hb;
        private Hashtable cursors;
        private Stack cursorStack;

        public DisplayHelpAfterTracking(HelpBroker hb) {
            if (hb == null) {
                throw new NullPointerException("hb");
            }
            this.hb = hb;
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            Component topComp = null;
            Cursor onItemCursor = (Cursor)UIManager.get("HelpOnItemCursor");
            if (onItemCursor == null) {
                return;
            }
            if (source instanceof Component) {
                topComp = this.getTopComponentForComponent((Component)source);
            } else if (source instanceof MenuItem) {
                topComp = this.getTopComponentForMenuItem((MenuItem)source);
            } else {
                return;
            }
            if (onItemCursor != null && topComp != null) {
                this.setCursor(topComp, onItemCursor);
            }
            Object obj = CSH.trackCSEvents();
            if (onItemCursor != null && topComp != null) {
                this.resetAndRestoreCursors(topComp);
            }
            this.setCursor(topComp, new Cursor(3));
            Component comp = (Component)e.getSource();
            try {
                Window owner = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), comp);
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow(owner);
                }
            }
            catch (ClassNotFoundException owner) {
                // empty catch block
            }
            String helpID = null;
            HelpSet hs = null;
            if (obj != null && obj instanceof Component) {
                helpID = CSH.getHelpIDString((Component)obj);
                hs = CSH.getHelpSet((Component)obj);
            } else if (obj != null && obj instanceof MenuItem) {
                helpID = CSH.getHelpIDString((MenuItem)obj);
                hs = CSH.getHelpSet((MenuItem)obj);
            }
            if (hs == null) {
                hs = this.hb.getHelpSet();
            }
            Map.ID id = null;
            try {
                id = Map.ID.create(helpID, hs);
                if (id == null) {
                    id = hs.getHomeID();
                }
            }
            catch (Exception e2) {
                System.out.println(e2);
            }
            try {
                if (id == null) {
                    id = hs.getHomeID();
                }
                this.hb.setCurrentID(id);
                this.hb.setDisplayed(true);
            }
            catch (Exception e3) {
                System.out.println(e3);
            }
            this.resetAndRestoreCursors(topComp);
        }

        private Component getTopComponentForComponent(Component comp) {
            Component parent;
            Component tcomp = comp;
            if (comp instanceof MenuElement) {
                tcomp = comp instanceof JPopupMenu ? ((JPopupMenu)comp).getInvoker() : ((MenuElement)((Object)comp)).getComponent();
            }
            if ((parent = tcomp.getParent()) instanceof MenuElement) {
                parent = parent instanceof JPopupMenu ? ((JPopupMenu)parent).getInvoker() : ((MenuElement)((Object)parent)).getComponent();
            }
            while (parent != null) {
                tcomp = parent;
                if (!((parent = tcomp.getParent()) instanceof MenuElement)) continue;
                parent = parent instanceof JPopupMenu ? ((JPopupMenu)parent).getInvoker() : ((MenuElement)((Object)parent)).getComponent();
            }
            return tcomp;
        }

        private Component getTopComponentForMenuItem(MenuItem mi) {
            MenuContainer tmcont;
            MenuContainer parent = tmcont = mi.getParent();
            while (parent != null) {
                if (parent instanceof Component) break;
                tmcont = parent;
                parent = ((MenuComponent)((Object)tmcont)).getParent();
            }
            if (parent == null) {
                return null;
            }
            Component comp = this.getTopComponentForComponent((Component)parent);
            return comp;
        }

        private void setCursor(Component comp, Cursor cursor) {
            CSH.debug("setCursors");
            this.cursors = new Hashtable();
            this.cursorStack = new Stack();
            this.setAndStoreCursors(comp, cursor);
        }

        private void setAndStoreCursors(Component comp, Cursor cursor) {
            boolean addedToStack = false;
            Cursor compCursor = comp.getCursor();
            if (this.cursorStack.empty()) {
                this.cursorStack.push(compCursor);
                this.cursors.put(comp, compCursor);
                addedToStack = true;
                CSH.debug("store cursor " + compCursor + " on " + comp);
            } else if (compCursor != (Cursor)this.cursorStack.peek()) {
                this.cursorStack.push(compCursor);
                this.cursors.put(comp, compCursor);
                addedToStack = true;
                CSH.debug("store cursor " + compCursor + " on " + comp);
            }
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                int ncomponents = cont.getComponentCount();
                Component[] component = cont.getComponents();
                int i = 0;
                while (i < ncomponents) {
                    Component comp2 = component[i];
                    if (comp != null) {
                        this.setAndStoreCursors(comp2, cursor);
                    }
                    ++i;
                }
            }
            comp.setCursor(cursor);
            CSH.debug("set cursor on " + comp);
            if (addedToStack) {
                this.cursorStack.pop();
            }
        }

        private void resetAndRestoreCursors(Component comp) {
            CSH.debug("resetAndRestoreCursors");
            this.cursorStack = new Stack();
            this.restoreCursors(comp);
            this.cursors = null;
            this.cursorStack = null;
        }

        private void restoreCursors(Component comp) {
            boolean addedToStack = false;
            Cursor oldCursor = (Cursor)this.cursors.get(comp);
            if (oldCursor != null) {
                this.cursorStack.push(oldCursor);
                comp.setCursor(oldCursor);
                CSH.debug("restored cursor " + oldCursor + " on " + comp);
                addedToStack = true;
            } else if (!this.cursorStack.empty()) {
                comp.setCursor((Cursor)this.cursorStack.peek());
                CSH.debug("restored cursor " + (Cursor)this.cursorStack.peek() + " on " + comp);
            }
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                int ncomponents = cont.getComponentCount();
                Component[] component = cont.getComponents();
                int i = 0;
                while (i < ncomponents) {
                    Component comp2 = component[i];
                    if (comp != null) {
                        this.restoreCursors(comp2);
                    }
                    ++i;
                }
            }
            if (addedToStack) {
                this.cursorStack.pop();
            }
        }
    }

    public static class DisplayHelpFromSource
    implements ActionListener {
        private HelpBroker hb;

        public DisplayHelpFromSource(HelpBroker hb) {
            if (hb == null) {
                throw new NullPointerException("hb");
            }
            this.hb = hb;
        }

        public void actionPerformed(ActionEvent e) {
            Window owner;
            Object source = e.getSource();
            if (source instanceof Component) {
                Component comp = (Component)e.getSource();
                if (comp instanceof JMenuItem) {
                    while (comp instanceof JMenuItem) {
                        Container parent = comp.getParent();
                        if (!(parent instanceof JPopupMenu)) break;
                        comp = ((JPopupMenu)parent).getInvoker();
                    }
                }
                try {
                    owner = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), comp);
                    CSH.debug("owner = " + owner);
                    if (this.hb instanceof DefaultHelpBroker) {
                        ((DefaultHelpBroker)this.hb).setActivationWindow(owner);
                    }
                }
                catch (ClassNotFoundException ex) {}
            } else if (source instanceof MenuItem) {
                block28: {
                    MenuContainer mc;
                    MenuItem mi = (MenuItem)e.getSource();
                    owner = null;
                    while (true) {
                        if ((mc = mi.getParent()) instanceof Menu) {
                            mi = (MenuItem)((Object)mc);
                            continue;
                        }
                        if (mc instanceof MenuBar) {
                            try {
                                owner = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)((MenuBar)mc).getParent());
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                            break block28;
                        }
                        if (mc instanceof Frame) {
                            owner = (Window)mc;
                            break block28;
                        }
                        if (mc instanceof Component) break;
                    }
                    try {
                        owner = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)mc);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                CSH.debug("owner = " + owner);
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow(owner);
                }
            }
            String helpID = null;
            HelpSet hs = null;
            if (source instanceof Component) {
                Component compSource = (Component)source;
                helpID = CSH.getHelpIDString(compSource);
                hs = CSH.getHelpSet(compSource);
            } else if (source instanceof MenuItem) {
                MenuItem miSource = (MenuItem)source;
                helpID = CSH.getHelpIDString(miSource);
                hs = CSH.getHelpSet(miSource);
            } else {
                return;
            }
            if (hs == null) {
                hs = this.hb.getHelpSet();
            }
            try {
                Map.ID id = null;
                try {
                    id = Map.ID.create(helpID, hs);
                }
                catch (BadIDException bide) {
                    System.err.println(bide);
                }
                if (id == null) {
                    id = hs.getHomeID();
                }
                this.hb.setCurrentID(id);
                this.hb.setDisplayed(true);
            }
            catch (Exception e2) {
                System.err.println("trouble in HelpActionListener");
                e2.printStackTrace();
            }
        }
    }
}

