/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.util.ObjectDescriptionException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractModelReader {
    private static final int STATE_START = 0;
    private static final int IN_OBJECT = 1;
    private static final int IGNORE_OBJECT = 2;
    private static final int MAPPING_STATE = 3;
    private static final int CONSTRUCTOR_STATE = 4;

    protected void parseXml(URL uRL) throws ObjectDescriptionException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new InputSource(bufferedInputStream), (DefaultHandler)new SAXModelHandler(uRL));
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ObjectDescriptionException("Unable to load object factory specs.", exception);
        }
    }

    protected void handleIgnoredProperty(String string) {
    }

    protected abstract boolean handleManualMapping(String var1, String var2, String var3) throws ObjectDescriptionException;

    protected abstract boolean startObjectDefinition(String var1, String var2, boolean var3) throws ObjectDescriptionException;

    protected abstract void handleAttributeDefinition(String var1, String var2, String var3) throws ObjectDescriptionException;

    protected abstract void handleElementDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void handleLookupDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void endObjectDefinition() throws ObjectDescriptionException;

    protected abstract void startMultiplexMapping(String var1, String var2);

    protected abstract void handleMultiplexMapping(String var1, String var2) throws ObjectDescriptionException;

    protected abstract void endMultiplexMapping() throws ObjectDescriptionException;

    protected abstract void handleConstructorDefinition(String var1, String var2) throws ObjectDescriptionException;

    protected Class loadClass(String string) {
        if (string == null) {
            return null;
        }
        try {
            return this.getClass().getClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            System.out.println("Unable to handle " + string);
            exception.printStackTrace();
            return null;
        }
    }

    private class SAXModelHandler
    extends DefaultHandler {
        private URL resource;
        private int state;

        public SAXModelHandler(URL uRL) {
            if (uRL == null) {
                throw new NullPointerException();
            }
            this.resource = uRL;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (this.getState() == 0) {
                    this.startRootElement(string3, attributes);
                } else {
                    if (this.getState() == 2) {
                        return;
                    }
                    if (this.getState() == 1) {
                        this.startObjectElement(string3, attributes);
                    } else if (this.getState() == 3) {
                        if (!string3.equals("type")) {
                            throw new SAXException("Expected 'type' tag");
                        }
                        String string4 = attributes.getValue("name");
                        String string5 = attributes.getValue("class");
                        AbstractModelReader.this.handleMultiplexMapping(string4, string5);
                    } else if (this.getState() == 4) {
                        if (!string3.equals("parameter")) {
                            throw new SAXException("Expected 'parameter' tag");
                        }
                        String string6 = attributes.getValue("class");
                        String string7 = attributes.getValue("property");
                        AbstractModelReader.this.handleConstructorDefinition(string7, string6);
                    }
                }
            }
            catch (ObjectDescriptionException objectDescriptionException) {
                throw new SAXException(objectDescriptionException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            try {
                if (string3.equals("object")) {
                    if (this.getState() != 2) {
                        AbstractModelReader.this.endObjectDefinition();
                    }
                    this.setState(0);
                } else if (string3.equals("mapping")) {
                    this.setState(0);
                    AbstractModelReader.this.endMultiplexMapping();
                } else if (string3.equals("constructor") && this.getState() != 2) {
                    this.setState(1);
                }
            }
            catch (ObjectDescriptionException objectDescriptionException) {
                throw new SAXException(objectDescriptionException);
            }
        }

        private void startObjectElement(String string, Attributes attributes) throws ObjectDescriptionException {
            if (string.equals("constructor")) {
                this.setState(4);
            } else if (string.equals("lookup")) {
                String string2 = attributes.getValue("name");
                String string3 = attributes.getValue("lookup");
                AbstractModelReader.this.handleLookupDefinition(string2, string3);
            } else if (string.equals("ignore")) {
                String string4 = attributes.getValue("name");
                AbstractModelReader.this.handleIgnoredProperty(string4);
            } else if (string.equals("element-property")) {
                String string5 = attributes.getValue("element");
                String string6 = attributes.getValue("name");
                AbstractModelReader.this.handleElementDefinition(string6, string5);
            } else if (string.equals("attribute-property")) {
                String string7 = attributes.getValue("name");
                String string8 = attributes.getValue("attribute");
                String string9 = attributes.getValue("handler");
                AbstractModelReader.this.handleAttributeDefinition(string7, string8, string9);
            }
        }

        private void startRootElement(String string, Attributes attributes) throws SAXException, ObjectDescriptionException {
            if (string.equals("include")) {
                String string2 = attributes.getValue("src");
                try {
                    AbstractModelReader.this.parseXml(new URL(this.resource, string2));
                }
                catch (Exception exception) {
                    throw new ElementDefinitionException(exception, "Unable to include file from " + string2);
                }
            } else if (string.equals("object")) {
                boolean bl;
                this.setState(1);
                String string3 = attributes.getValue("class");
                String string4 = attributes.getValue("register-name");
                if (string4 != null && string4.length() == 0) {
                    string4 = null;
                }
                if (!AbstractModelReader.this.startObjectDefinition(string3, string4, bl = "true".equals(attributes.getValue("ignore")))) {
                    System.out.println("Start to ignore ---");
                    this.setState(2);
                }
            } else if (string.equals("manual")) {
                String string5 = attributes.getValue("class");
                String string6 = attributes.getValue("read-handler");
                String string7 = attributes.getValue("write-handler");
                AbstractModelReader.this.handleManualMapping(string5, string6, string7);
            } else if (string.equals("mapping")) {
                this.setState(3);
                String string8 = attributes.getValue("type-attribute");
                String string9 = attributes.getValue("base-class");
                AbstractModelReader.this.startMultiplexMapping(string9, string8);
            }
        }

        private int getState() {
            return this.state;
        }

        private void setState(int n) {
            this.state = n;
        }
    }
}

