/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class TextFragment {
    public static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    private String text;
    private Font font;

    public TextFragment(String string) {
        this(string, DEFAULT_FONT);
    }

    public TextFragment(String string, Font font) {
        this.text = string;
        this.font = font;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public Dimension calculateDimensions(Graphics2D graphics2D) {
        Dimension dimension = new Dimension();
        graphics2D.setFont(this.font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.text, graphics2D);
        dimension.setSize(rectangle2D.getWidth(), rectangle2D.getHeight());
        return dimension;
    }

    public void draw(Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor, float f3, float f4, double d) {
        graphics2D.setFont(this.font);
        RefineryUtilities.drawRotatedString(this.text, graphics2D, f, f2, textAnchor, f3, f4, d);
    }

    public float calculateBaselineOffset(Graphics2D graphics2D, TextAnchor textAnchor) {
        float f = 0.0f;
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        LineMetrics lineMetrics = fontMetrics.getLineMetrics("ABCxyz", graphics2D);
        if (textAnchor == TextAnchor.TOP_LEFT || textAnchor == TextAnchor.TOP_CENTER || textAnchor == TextAnchor.TOP_RIGHT) {
            f = lineMetrics.getAscent();
        } else if (textAnchor == TextAnchor.BOTTOM_LEFT || textAnchor == TextAnchor.BOTTOM_CENTER || textAnchor == TextAnchor.BOTTOM_RIGHT) {
            f = -lineMetrics.getDescent() - lineMetrics.getLeading();
        }
        return f;
    }
}

