/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class JSpinField
extends JPanel
implements CaretListener,
AdjustmentListener,
ActionListener {
    protected JTextField textField;
    protected JScrollBar scrollBar;
    private Color darkGreen = new Color(0, 150, 0);
    private int min = 0;
    private int max = 100;
    private int value = 0;

    public JSpinField() {
        this.setLayout(new BorderLayout());
        this.textField = new JTextField(Integer.toString(this.value));
        this.textField.addCaretListener(this);
        this.textField.addActionListener(this);
        this.add((Component)this.textField, "Center");
        this.scrollBar = new JScrollBar(1, 0, 0, 0, 100);
        this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.scrollBar.setMinimum(this.min);
        this.scrollBar.setMaximum(this.max);
        this.scrollBar.setValue(this.max + this.min - this.value);
        this.scrollBar.setVisibleAmount(0);
        this.scrollBar.addAdjustmentListener(this);
        this.add((Component)this.scrollBar, "East");
    }

    protected void setValue(int n, boolean bl, boolean bl2) {
        int n2 = this.value;
        this.value = n < this.min ? this.min : (n > this.max ? this.max : n);
        if (bl) {
            this.textField.setText(Integer.toString(this.value));
            this.textField.setForeground(Color.black);
        }
        if (bl2) {
            this.scrollBar.setValue(this.max + this.min - this.value);
        }
        this.firePropertyChange("value", n2, this.value);
    }

    public void setValue(int n) {
        this.setValue(n, true, true);
    }

    public int getValue() {
        return this.value;
    }

    public void setMinimum(int n) {
        this.min = n;
        this.scrollBar.setMinimum(this.min);
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMaximum(int n) {
        this.max = n;
        this.scrollBar.setMaximum(this.max);
    }

    public int getMaximum() {
        return this.max;
    }

    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public void setForeground(Color color) {
        if (this.textField != null) {
            this.textField.setForeground(color);
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        block4: {
            try {
                int n = Integer.valueOf(this.textField.getText());
                if (n >= this.min && n <= this.max) {
                    this.textField.setForeground(this.darkGreen);
                    this.setValue(n, false, false);
                } else {
                    this.textField.setForeground(Color.red);
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof NumberFormatException)) break block4;
                this.textField.setForeground(Color.red);
            }
        }
        this.textField.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setValue(this.max + this.min - adjustmentEvent.getValue(), true, false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.textField.getForeground().equals(this.darkGreen)) {
            this.setValue(Integer.valueOf(this.textField.getText()));
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JSpinField");
        jFrame.getContentPane().add(new JSpinField());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

